/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.segment.reduce;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.inference.bean.segment.reduce.ReduceElements;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.ReductionOutcome;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.segment.reduce.DeriveObjectsFromStream;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.BoundingBoxMerger;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.rtree.SpatiallySeparate;

public class ThresholdConfidence
extends ReduceElements<ObjectMask> {
    @BeanField
    private double minConfidence = 0.5;
    @BeanField
    private int minNumberVoxels = 5;
    @BeanField
    private int thresholdNumberObjectsGlobal = 20;

    public ThresholdConfidence(double minConfidence) {
        this.minConfidence = minConfidence;
    }

    public ReductionOutcome<LabelledWithConfidence<ObjectMask>> reduce(List<LabelledWithConfidence<ObjectMask>> elements, Extent extent, ExecutionTimeRecorder executionTimeRecorder) throws OperationFailedException {
        List elementsFiltered = elements.stream().filter(withConfidence -> withConfidence.getConfidence() >= this.minConfidence).toList();
        if (elementsFiltered.isEmpty()) {
            return new ReductionOutcome();
        }
        String label = elementsFiltered.get(0).getLabel();
        if (ThresholdConfidence.anyLabelDiffersTo(elementsFiltered, label)) {
            throw new OperationFailedException("Labels are not all identical, so this reduction operation cannot proceed.");
        }
        ReductionOutcome outcome = new ReductionOutcome();
        executionTimeRecorder.recordExecutionTime("Derive labelled reduced objects", () -> this.projectAllObjects(elementsFiltered, extent, withConfidence -> outcome.addNewlyAdded((Object)new LabelledWithConfidence(label, withConfidence)), executionTimeRecorder));
        return outcome;
    }

    private void projectAllObjects(List<LabelledWithConfidence<ObjectMask>> elements, Extent extent, Consumer<WithConfidence<ObjectMask>> addToOutcome, ExecutionTimeRecorder executionTimeRecorder) throws OperationFailedException {
        if (elements.size() >= this.thresholdNumberObjectsGlobal) {
            this.deriveObjects(elements.stream(), new BoundingBox(extent), addToOutcome);
        } else {
            this.projectSeparatedObjects(elements, addToOutcome, executionTimeRecorder);
        }
    }

    private void projectSeparatedObjects(List<LabelledWithConfidence<ObjectMask>> elements, Consumer<WithConfidence<ObjectMask>> addToOutcome, ExecutionTimeRecorder executionTimeRecorder) throws OperationFailedException {
        SpatiallySeparate separate = new SpatiallySeparate(withConfidence -> ((ObjectMask)withConfidence.getElement()).boundingBox());
        List separatedElements = (List)executionTimeRecorder.recordExecutionTime("Spatially separate for reduction", () -> separate.separate((Collection)elements));
        for (Set split : separatedElements) {
            BoundingBox mergedBox = BoundingBoxMerger.merge(split.stream().map(withConfidence -> ((ObjectMask)withConfidence.getElement()).boundingBox()));
            this.deriveObjects(split.stream(), mergedBox, addToOutcome);
        }
    }

    private void deriveObjects(Stream<LabelledWithConfidence<ObjectMask>> elements, BoundingBox box, Consumer<WithConfidence<ObjectMask>> addToOutcome) throws OperationFailedException {
        DeriveObjectsFromStream.deriveObjects(elements.map(LabelledWithConfidence::getWithConfidence), box, this.minConfidence, this.minNumberVoxels).stream().forEach(addToOutcome);
    }

    private static <T> boolean anyLabelDiffersTo(List<LabelledWithConfidence<T>> elements, String labelToCompare) {
        return elements.stream().map(LabelledWithConfidence::getLabel).anyMatch(label -> !labelToCompare.equals(label));
    }

    @Generated
    public ThresholdConfidence() {
    }

    @Generated
    public double getMinConfidence() {
        return this.minConfidence;
    }

    @Generated
    public void setMinConfidence(double minConfidence) {
        this.minConfidence = minConfidence;
    }

    @Generated
    public int getMinNumberVoxels() {
        return this.minNumberVoxels;
    }

    @Generated
    public void setMinNumberVoxels(int minNumberVoxels) {
        this.minNumberVoxels = minNumberVoxels;
    }

    @Generated
    public int getThresholdNumberObjectsGlobal() {
        return this.thresholdNumberObjectsGlobal;
    }

    @Generated
    public void setThresholdNumberObjectsGlobal(int thresholdNumberObjectsGlobal) {
        this.thresholdNumberObjectsGlobal = thresholdNumberObjectsGlobal;
    }
}

