/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.scale;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.RelativeScaleCalculator;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class FindLargestMultipleWithin {
    public static int apply(Extent small, Extent stayWithin, int maxScaleFactor) throws OperationFailedException {
        if (small.x() > stayWithin.x()) {
            throw new OperationFailedException("The extent of small in the X direction is already larger than stayWithin. This is not allowed");
        }
        if (small.y() > stayWithin.y()) {
            throw new OperationFailedException("The extent of small in the Y direction is already larger than stayWithin. This is not allowed");
        }
        ScaleFactor scaleFactor = RelativeScaleCalculator.relativeScale((Extent)small, (Extent)stayWithin);
        return FindLargestMultipleWithin.minScaleFactorUnder(scaleFactor, maxScaleFactor);
    }

    private static int minScaleFactorUnder(ScaleFactor sf, int maxScaleFactor) {
        int min = FindLargestMultipleWithin.minScaleFactor(sf);
        return Math.min(min, maxScaleFactor);
    }

    private static int minScaleFactor(ScaleFactor sf) {
        return (int)Math.floor(Math.min(sf.x(), sf.y()));
    }

    @Generated
    private FindLargestMultipleWithin() {
    }
}

