/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.segment.binary;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;

public class Sequence
extends BinarySegmentation {
    @BeanField
    @OptionalBean
    private List<BinarySegmentation> list = new ArrayList<BinarySegmentation>();

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.list.isEmpty()) {
            throw new BeanMisconfiguredException("At least one item is required in listSgmn");
        }
    }

    public BinaryVoxels<UnsignedByteBuffer> segment(VoxelsUntyped voxels, BinarySegmentationParameters parameters, Optional<ObjectMask> objectMask) throws SegmentationFailedException {
        BinaryVoxels out = null;
        BoundingBox box = objectMask.map(ObjectMask::boundingBox).orElseGet(() -> new BoundingBox(voxels.extent()));
        Optional<ObjectMask> evolvingMask = objectMask;
        for (BinarySegmentation segment : this.list) {
            BinaryVoxels outNew;
            out = outNew = segment.segment(voxels, parameters, evolvingMask);
            evolvingMask = Optional.of(new ObjectMask(box, outNew));
        }
        return out;
    }

    @Generated
    public List<BinarySegmentation> getList() {
        return this.list;
    }

    @Generated
    public void setList(List<BinarySegmentation> list) {
        this.list = list;
    }
}

