/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.segment.binary;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.segment.thresholder.slice.SliceThresholder;
import org.anchoranalysis.plugin.image.segment.thresholder.slice.SliceThresholderMask;
import org.anchoranalysis.plugin.image.segment.thresholder.slice.SliceThresholderWithoutMask;
import org.anchoranalysis.spatial.box.Extent;

public class ThresholdAgainstChannel
extends BinarySegmentation {
    @BeanField
    private ChannelProvider channelThreshold;
    @BeanField
    private boolean clearOutsideMask = true;

    public BinaryVoxels<UnsignedByteBuffer> segment(VoxelsUntyped voxels, BinarySegmentationParameters parameters, Optional<ObjectMask> object) throws SegmentationFailedException {
        Voxels voxelsIn = voxels.any();
        Voxels<UnsignedByteBuffer> voxelsOut = this.createOutputVoxels(voxels);
        BinaryValuesByte binaryValues = BinaryValuesByte.getDefault();
        SliceThresholder sliceThresholder = this.createThresholder(object, binaryValues);
        sliceThresholder.segmentAll(voxelsIn, this.createThresholdedVoxels(voxels.any().extent()), this.createOutputVoxels(voxels));
        return BinaryVoxelsFactory.reuseByte(voxelsOut, (BinaryValuesInt)binaryValues.asInt());
    }

    private SliceThresholder createThresholder(Optional<ObjectMask> object, BinaryValuesByte binaryValues) {
        return object.map(objectMask -> new SliceThresholderMask(this.clearOutsideMask, (ObjectMask)objectMask, binaryValues)).orElseGet(() -> new SliceThresholderWithoutMask(binaryValues));
    }

    private Voxels<?> createThresholdedVoxels(Extent voxelsExtent) throws SegmentationFailedException {
        Channel threshold;
        try {
            threshold = (Channel)this.channelThreshold.get();
        }
        catch (ProvisionFailedException e) {
            throw new SegmentationFailedException((Throwable)e);
        }
        Voxels voxelsThresholded = threshold.voxels().any();
        if (!voxelsThresholded.extent().equals((Object)voxelsExtent)) {
            throw new SegmentationFailedException("channelProviderThrshld is of different size to voxels");
        }
        return voxelsThresholded;
    }

    private Voxels<UnsignedByteBuffer> createOutputVoxels(VoxelsUntyped voxels) {
        if (voxels.getVoxelDataType().equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            return voxels.asByte();
        }
        return VoxelsFactory.getUnsignedByte().createInitialized(voxels.any().extent());
    }

    @Generated
    public ChannelProvider getChannelThreshold() {
        return this.channelThreshold;
    }

    @Generated
    public void setChannelThreshold(ChannelProvider channelThreshold) {
        this.channelThreshold = channelThreshold;
    }

    @Generated
    public boolean isClearOutsideMask() {
        return this.clearOutsideMask;
    }

    @Generated
    public void setClearOutsideMask(boolean clearOutsideMask) {
        this.clearOutsideMask = clearOutsideMask;
    }
}

