/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.stack.provider.color;

import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.plugin.image.bean.stack.provider.color.ColoredBase;
import org.anchoranalysis.plugin.image.object.ColoredObjectCollection;

public class ThreeColoredObjects
extends ColoredBase {
    private static final RGBColor COLOR_RED = new RGBColor(255, 0, 0);
    private static final RGBColor COLOR_GREEN = new RGBColor(0, 255, 0);
    private static final RGBColor COLOR_BLUE = new RGBColor(0, 0, 255);
    @BeanField
    @OptionalBean
    private ObjectCollectionProvider objectsRed;
    @BeanField
    @OptionalBean
    private ObjectCollectionProvider objectsBlue;
    @BeanField
    @OptionalBean
    private ObjectCollectionProvider objectsGreen;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.objectsRed == null && this.objectsBlue == null && this.objectsGreen == null) {
            throw new BeanMisconfiguredException("Either objectsRed or objectsBlue or objectsGreen must be non-null");
        }
    }

    @Override
    protected ColoredObjectCollection coloredObjectsToDraw(Dimensions backgroundDimensions) throws CreateException {
        ColoredObjectCollection objects = new ColoredObjectCollection();
        try {
            objects.addObjectsWithColor(this.objectsRed, COLOR_RED);
            objects.addObjectsWithColor(this.objectsGreen, COLOR_GREEN);
            objects.addObjectsWithColor(this.objectsBlue, COLOR_BLUE);
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
        return objects;
    }

    @Generated
    public ObjectCollectionProvider getObjectsRed() {
        return this.objectsRed;
    }

    @Generated
    public void setObjectsRed(ObjectCollectionProvider objectsRed) {
        this.objectsRed = objectsRed;
    }

    @Generated
    public ObjectCollectionProvider getObjectsBlue() {
        return this.objectsBlue;
    }

    @Generated
    public void setObjectsBlue(ObjectCollectionProvider objectsBlue) {
        this.objectsBlue = objectsBlue;
    }

    @Generated
    public ObjectCollectionProvider getObjectsGreen() {
        return this.objectsGreen;
    }

    @Generated
    public void setObjectsGreen(ObjectCollectionProvider objectsGreen) {
        this.objectsGreen = objectsGreen;
    }
}

