/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.thumbnail.object;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.box.ScaleableBackground;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class BackgroundSelector {
    private int backgroundChannelIndex;
    private ScaleFactor scaleFactor;
    private VoxelsResizer resizer;
    private StackDisplayer displayer;

    public Optional<ScaleableBackground> determineBackground(Optional<Stack> backgroundSource) throws OperationFailedException {
        return OptionalUtilities.flatMap(backgroundSource, this::determineScaledBackground);
    }

    private Optional<ScaleableBackground> determineScaledBackground(Stack backgroundSource) throws OperationFailedException {
        try {
            return this.determineBackground(backgroundSource).map(stack -> ScaleableBackground.scaleBy((DisplayStack)stack, (ScaleFactor)this.scaleFactor, (VoxelsResizer)this.resizer));
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private Optional<DisplayStack> determineBackground(Stack backgroundSource) throws CreateException {
        if (this.backgroundChannelIndex > -1) {
            return Optional.of(this.extractChannelAsStack(backgroundSource, this.backgroundChannelIndex));
        }
        int numberChannels = backgroundSource.getNumberChannels();
        return switch (numberChannels) {
            case 0 -> Optional.empty();
            case 1, 3 -> Optional.of(this.displayer.deriveFrom(backgroundSource));
            default -> Optional.of(this.extractChannelAsStack(backgroundSource, 0));
        };
    }

    private DisplayStack extractChannelAsStack(Stack stack, int index) throws CreateException {
        return this.displayer.deriveFrom(stack.getChannel(index));
    }

    @Generated
    public BackgroundSelector(int backgroundChannelIndex, ScaleFactor scaleFactor, VoxelsResizer resizer, StackDisplayer displayer) {
        this.backgroundChannelIndex = backgroundChannelIndex;
        this.scaleFactor = scaleFactor;
        this.resizer = resizer;
        this.displayer = displayer;
    }
}

