/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.thumbnail.object;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3i;

class CenterBoundingBoxHelper {
    public static BoundingBox deriveCenteredBoxWithSize(BoundingBox boxToBeCentered, Extent targetSize, Extent sceneExtent) throws OperationFailedException {
        CenterBoundingBoxHelper.checkArguments(boxToBeCentered, targetSize, sceneExtent);
        ReadableTuple3i targetSizeAsTuple = targetSize.asTuple();
        Tuple3i idealShiftDown = CenterBoundingBoxHelper.idealShiftDown(boxToBeCentered, targetSizeAsTuple);
        Point3i cornerLeft = Point3i.immutableSubtract((ReadableTuple3i)boxToBeCentered.cornerMin(), (ReadableTuple3i)idealShiftDown);
        CenterBoundingBoxHelper.pushUpIfNecessary(cornerLeft);
        return CenterBoundingBoxHelper.pushDownIfNecessary(cornerLeft, targetSizeAsTuple, sceneExtent);
    }

    private static Tuple3i idealShiftDown(BoundingBox boxToBeCentered, ReadableTuple3i targetSizeAsTuple) {
        Point3i difference = Point3i.immutableSubtract((ReadableTuple3i)targetSizeAsTuple, (ReadableTuple3i)boxToBeCentered.extent().asTuple());
        difference.scale(0.5);
        return difference;
    }

    private static void pushUpIfNecessary(Point3i cornerLeft) {
        Point3i toSubtract = CenterBoundingBoxHelper.keepOnlyNegative(cornerLeft);
        cornerLeft.subtract((ReadableTuple3i)toSubtract);
    }

    private static BoundingBox pushDownIfNecessary(Point3i cornerLeft, ReadableTuple3i targetSizeAsTuple, Extent sceneExtent) {
        Point3i cornerRight = Point3i.immutableAdd((ReadableTuple3i)cornerLeft, (ReadableTuple3i)targetSizeAsTuple);
        Point3i toSubtract = CenterBoundingBoxHelper.keepOnlyExcess(cornerRight, sceneExtent);
        cornerLeft.subtract((ReadableTuple3i)toSubtract);
        cornerRight.subtract((ReadableTuple3i)toSubtract);
        cornerRight.subtract(1);
        assert (sceneExtent.contains((ReadableTuple3i)cornerLeft));
        assert (sceneExtent.contains((ReadableTuple3i)cornerRight));
        return BoundingBox.createReuse((ReadableTuple3i)cornerLeft, (ReadableTuple3i)cornerRight);
    }

    private static Point3i keepOnlyNegative(Point3i point) {
        return new Point3i(CenterBoundingBoxHelper.negativeOrZero(point.x()), CenterBoundingBoxHelper.negativeOrZero(point.y()), CenterBoundingBoxHelper.negativeOrZero(point.z()));
    }

    private static Point3i keepOnlyExcess(Point3i point, Extent sceneExtent) {
        return new Point3i(CenterBoundingBoxHelper.keepOnlyExcess(point.x(), sceneExtent.x()), CenterBoundingBoxHelper.keepOnlyExcess(point.y(), sceneExtent.y()), CenterBoundingBoxHelper.keepOnlyExcess(point.z(), sceneExtent.z()));
    }

    private static int negativeOrZero(int value) {
        if (value < 0) {
            return value;
        }
        return 0;
    }

    private static int keepOnlyExcess(int value, int boundary) {
        if (value > boundary) {
            return value - boundary;
        }
        return 0;
    }

    private static void checkArguments(BoundingBox boxToBeCentered, Extent targetSize, Extent sceneExtent) throws OperationFailedException {
        if (boxToBeCentered.extent().anyDimensionIsLargerThan(targetSize)) {
            throw new OperationFailedException(String.format("The existing bounding-box (%s) is larger than the target-size (%s)", boxToBeCentered.extent(), targetSize));
        }
        if (!sceneExtent.contains(boxToBeCentered)) {
            throw new OperationFailedException(String.format("The box to be centered (%s) is not contained within the extent (%s)", boxToBeCentered.extent(), sceneExtent));
        }
    }

    @Generated
    private CenterBoundingBoxHelper() {
    }
}

