/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.thumbnail.object;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.core.functional.StreamableCollection;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.index.GetOperationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.scale.ScaledElements;
import org.anchoranalysis.image.core.object.scale.Scaler;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.box.ScaleableBackground;
import org.anchoranalysis.image.voxel.object.IntersectingObjects;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.ExtentToFitBoundingBoxes;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.ScaleFactorCalculator;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class FlattenAndScaler {
    private final ScaleFactor scaleFactor;
    private final VoxelsResizer resizer;
    private ScaledElements<ObjectMask> objectsScaled;
    private IntersectingObjects<ObjectMask> objectsIndexed;
    private Optional<ScaleableBackground> background;
    private Optional<Extent> sizeScaled;

    public FlattenAndScaler(StreamableCollection<BoundingBox> boundingBoxes, ObjectCollection allObjects, boolean overlappingObjects, VoxelsResizer resizer, Extent targetSize, CheckedFunction<ScaleFactor, Optional<ScaleableBackground>, OperationFailedException> backgroundCreator) throws OperationFailedException {
        this.scaleFactor = ScaleFactorCalculator.soEachBoundingBoxFits(boundingBoxes, targetSize);
        this.resizer = resizer;
        this.background = (Optional)backgroundCreator.apply((Object)this.scaleFactor);
        this.sizeScaled = this.background.map(ScaleableBackground::sizeAfterAnyScaling);
        this.objectsScaled = Scaler.scaleObjects((ObjectCollection)allObjects, (ScaleFactor)this.scaleFactor, (boolean)overlappingObjects, Optional.of(ObjectMask::flattenZ), Optional.of(this::clipToScaledSizeIfKnown));
        this.objectsIndexed = IntersectingObjects.create((ObjectCollection)ObjectCollectionFactory.of((Collection[])new Collection[]{this.objectsScaled.asCollectionOrderNotPreserved()}));
    }

    private ObjectMask clipToScaledSizeIfKnown(ObjectMask object) {
        if (this.sizeScaled.isPresent()) {
            return object.clampTo(this.sizeScaled.get());
        }
        return object;
    }

    public Optional<Stack> scaleStack(Optional<Stack> stack) {
        try {
            return OptionalUtilities.map(stack, this::flattenScaleAndRemoveResolution);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public Extent extentFromStackOrObjects(ObjectCollection objectsUnscaled) {
        return this.sizeScaled.orElseGet(() -> this.deriveScaledExtentFromObjects(objectsUnscaled));
    }

    public ObjectCollection scaleObjects(ObjectCollection objects) throws OperationFailedException {
        try {
            return objects.stream().map(arg_0 -> this.objectsScaled.scaledObjectFor(arg_0));
        }
        catch (GetOperationFailedException e) {
            throw e.asOperationFailedException();
        }
    }

    public ObjectCollection objectsThatIntersectWith(BoundingBox box, ObjectCollection excludeFromAdding) {
        Set intersectingObjects = this.objectsIndexed.intersectsWith(box);
        Set excludeSet = excludeFromAdding.stream().toSet();
        return new ObjectCollection(intersectingObjects.stream().filter(item -> !excludeSet.contains(item)));
    }

    private Stack flattenScaleAndRemoveResolution(Stack stack) throws OperationFailedException {
        return stack.mapChannel(this::flattenScaleAndRemoveResolutionFromChannel);
    }

    private Channel flattenScaleAndRemoveResolutionFromChannel(Channel channel) {
        Channel scaled = channel.projectMax().scaleXY(this.scaleFactor, this.resizer);
        scaled.assignResolution(Optional.empty());
        return scaled;
    }

    private Extent deriveScaledExtentFromObjects(ObjectCollection objects) {
        return ExtentToFitBoundingBoxes.derive(objects.streamStandardJava().map(object -> object.boundingBox().scale(this.scaleFactor).flattenZ()));
    }

    @Generated
    public FlattenAndScaler(ScaleFactor scaleFactor, VoxelsResizer resizer) {
        this.scaleFactor = scaleFactor;
        this.resizer = resizer;
    }

    @Generated
    public ScaleFactor getScaleFactor() {
        return this.scaleFactor;
    }

    @Generated
    public Optional<ScaleableBackground> getBackground() {
        return this.background;
    }
}

