/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.thumbnail.object;

import java.awt.Color;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.color.ColorIndex;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.box.DrawObjectOnStackGenerator;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.CenterBoundingBoxHelper;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.FlattenAndScaler;
import org.anchoranalysis.plugin.image.bean.thumbnail.object.ThumbnailColorIndex;
import org.anchoranalysis.plugin.image.thumbnail.ThumbnailBatch;
import org.anchoranalysis.spatial.box.BoundedList;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

class ThumbnailBatchOutline
implements ThumbnailBatch<ObjectCollection> {
    private final DrawObjectOnStackGenerator generator;
    private final FlattenAndScaler scaler;
    private final Extent sceneSizeScaled;
    private final Extent sceneSizeUnscaled;
    private final Optional<Color> colorUnselectedObjects;
    private final ExecutionTimeRecorder recorder;

    public ThumbnailBatchOutline(FlattenAndScaler scaler, ObjectCollection objectsUnscaled, Extent sceneSizeUnscaled, int outlineWidth, Optional<Color> colorUnselectedObjects, ExecutionTimeRecorder recorder) {
        this.scaler = scaler;
        this.colorUnselectedObjects = colorUnselectedObjects;
        this.sceneSizeUnscaled = sceneSizeUnscaled;
        this.recorder = recorder;
        this.sceneSizeScaled = scaler.extentFromStackOrObjects(objectsUnscaled);
        this.generator = DrawObjectOnStackGenerator.createFromStack(scaler.getBackground(), (int)outlineWidth, (ColorIndex)this.createColorIndex(false));
    }

    @Override
    public DisplayStack thumbnailFor(ObjectCollection element) throws CreateException {
        try {
            BoundedList objectsScaled = BoundedList.createFromList((List)this.scaler.scaleObjects(element).asList(), ObjectMask::boundingBox);
            assert (!objectsScaled.boundingBox().extent().anyDimensionIsLargerThan(this.sceneSizeUnscaled));
            BoundingBox centeredBox = CenterBoundingBoxHelper.deriveCenteredBoxWithSize(objectsScaled.boundingBox(), this.sceneSizeUnscaled, this.sceneSizeScaled);
            assert (centeredBox.extent().equals((Object)this.sceneSizeUnscaled));
            assert (this.sceneSizeScaled.contains(centeredBox));
            BoundedList<ObjectMask> objectsToDisplay = this.determineObjectsForGenerator((BoundedList<ObjectMask>)objectsScaled, centeredBox);
            Stack transformed = (Stack)this.recorder.recordExecutionTime("Transforming thumbnail objects", () -> this.generator.transform(objectsToDisplay));
            return new DisplayStack(transformed);
        }
        catch (OperationFailedException | OutputWriteFailedException e) {
            throw new CreateException(e);
        }
    }

    private BoundedList<ObjectMask> determineObjectsForGenerator(BoundedList<ObjectMask> objectsScaled, BoundingBox centeredBox) {
        BoundedList objectsMapped = objectsScaled.assignBoundingBox(centeredBox);
        if (this.colorUnselectedObjects.isPresent()) {
            ObjectCollection intersectingObjects = this.scaler.objectsThatIntersectWith(objectsMapped.boundingBox(), ObjectCollectionFactory.of((Collection[])new Collection[]{objectsScaled.list()}));
            return objectsMapped.addObjectsNoBoundingBoxChange((Collection)intersectingObjects.asList());
        }
        return objectsMapped;
    }

    private ColorIndex createColorIndex(boolean pairs) {
        return new ThumbnailColorIndex(pairs, this.colorUnselectedObjects.orElse(Color.PINK));
    }
}

