/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.thumbnail.stack;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.spatial.SizeXY;
import org.anchoranalysis.image.core.stack.DisplayStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.plugin.image.bean.thumbnail.stack.ThumbnailFromStack;

public class ScaleToSize
extends ThumbnailFromStack {
    @BeanField
    private SizeXY size = new SizeXY(200, 200);
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;
    @BeanField
    @DefaultInstance
    private StackDisplayer displayer;
    private VoxelsResizer resizerCreated;

    @Override
    public void start() {
        this.resizerCreated = this.interpolator.voxelsResizer();
    }

    @Override
    public DisplayStack thumbnailFor(Stack stack) throws CreateException {
        try {
            Stack resized = stack.extractUpToThreeChannels().mapChannel(channel -> channel.projectMax().resizeXY(this.size.getWidth(), this.size.getHeight(), this.resizerCreated));
            return this.displayer.deriveFrom(resized);
        }
        catch (OperationFailedException e) {
            throw new CreateException((Throwable)e);
        }
    }

    @Generated
    public SizeXY getSize() {
        return this.size;
    }

    @Generated
    public void setSize(SizeXY size) {
        this.size = size;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Generated
    public StackDisplayer getDisplayer() {
        return this.displayer;
    }

    @Generated
    public void setDisplayer(StackDisplayer displayer) {
        this.displayer = displayer;
    }
}

