/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.channel;

import lombok.Generated;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;

public class DimensionsChecker {
    public static void check(Channel channel, Mask mask) throws ProvisionFailedException {
        if (!channel.dimensions().equals((Object)mask.dimensions())) {
            throw new ProvisionFailedException(String.format("channel (%s) and mask (%s) must have the same dimensions", channel.dimensions().toString(), mask.dimensions().toString()));
        }
    }

    public static void check(Channel channelToCheck, String channelToCheckName, Dimensions dimFromChannel) throws ProvisionFailedException {
        DimensionsChecker.check(channelToCheck.dimensions(), channelToCheckName, dimFromChannel);
    }

    public static void check(Mask maskToCheck, String channelToCheckName, Dimensions dimensionsFromChannel) throws ProvisionFailedException {
        DimensionsChecker.check(maskToCheck.dimensions(), channelToCheckName, dimensionsFromChannel);
    }

    public static Channel createSameSize(ChannelProvider provider, String providerName, Channel channelSameSize) throws ProvisionFailedException {
        Channel channelNew = (Channel)provider.get();
        DimensionsChecker.check(channelNew, providerName, channelSameSize.dimensions());
        return channelNew;
    }

    public static Mask createSameSize(MaskProvider provider, String providerName, Channel channelSameSize) throws ProvisionFailedException {
        Mask mask = (Mask)provider.get();
        DimensionsChecker.check(mask, providerName, channelSameSize.dimensions());
        return mask;
    }

    private static void check(Dimensions dimensionsToCheck, String channelToCheckName, Dimensions dimensionsFromChannel) throws ProvisionFailedException {
        if (!dimensionsFromChannel.equals((Object)dimensionsToCheck)) {
            throw new ProvisionFailedException(String.format("channel (%s) and %s (%s) must have the same dimensions", dimensionsFromChannel.toString(), channelToCheckName, dimensionsToCheck.toString()));
        }
    }

    @Generated
    private DimensionsChecker() {
    }
}

