/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.color.ColorList;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.object.ColoredObject;

public class ColoredObjectCollection {
    private final List<ColoredObject> list;

    public ColoredObjectCollection() {
        this.list = new LinkedList<ColoredObject>();
    }

    public ColoredObjectCollection(Stream<ColoredObject> stream) {
        this.list = stream.toList();
    }

    public ColoredObjectCollection(ObjectMask object, RGBColor color) {
        this.list = Arrays.asList(new ColoredObject(object, color));
    }

    public ColoredObjectCollection(ObjectCollection objects, ColorList colors) {
        Preconditions.checkArgument((objects.size() == colors.size() ? 1 : 0) != 0);
        this.list = FunctionalList.zip((Collection)objects.asList(), (Collection)colors.asList(), ColoredObject::new);
    }

    public void addObjectsWithColor(ObjectCollectionProvider provider, RGBColor color) throws OperationFailedException {
        try {
            Optional objects = OptionalProviderFactory.create((Provider)provider);
            if (objects.isPresent()) {
                this.addObjectsToList((ObjectCollection)objects.get(), color);
            }
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public ColoredObjectCollection flattenZ() {
        return new ColoredObjectCollection(this.list.stream().map(ColoredObject::flattenZ));
    }

    public ColorList deriveColorList() {
        return new ColorList(this.list.stream().map(ColoredObject::getColor));
    }

    public Stream<ObjectWithProperties> streamObjectWithProperties() {
        return this.list.stream().map(colored -> new ObjectWithProperties(colored.getObject()));
    }

    private void addObjectsToList(ObjectCollection objects, RGBColor color) {
        objects.asList().forEach(object -> this.list.add(new ColoredObject((ObjectMask)object, color)));
    }
}

