/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ObjectIntersectionRemover {
    public static ObjectCollection removeIntersectingVoxels(ObjectCollection objects, Dimensions dimensions, boolean errorDisconnectedObjects) throws OperationFailedException {
        ObjectCollection objectsDuplicated = objects.duplicate();
        for (int i = 0; i < objects.size(); ++i) {
            ObjectMask objectWrite = objectsDuplicated.get(i);
            if (errorDisconnectedObjects) {
                ObjectIntersectionRemover.maybeErrorDisconnectedObjects(objectWrite, "before");
            }
            for (int j = 0; j < objects.size(); ++j) {
                ObjectMask objectRead = objectsDuplicated.get(j);
                if (i >= j) continue;
                ObjectIntersectionRemover.removeIntersectingVoxelsIfIntersects(objectWrite, objectRead, dimensions);
            }
            if (!errorDisconnectedObjects) continue;
            ObjectIntersectionRemover.maybeErrorDisconnectedObjects(objectWrite, "after");
        }
        return objectsDuplicated;
    }

    private static void removeIntersectingVoxelsIfIntersects(ObjectMask objectWrite, ObjectMask objectRead, Dimensions dimensions) {
        Optional intersection = objectWrite.boundingBox().intersection().withInside(objectRead.boundingBox(), dimensions.extent());
        if (intersection.isPresent()) {
            ObjectIntersectionRemover.removeIntersectingVoxels(objectWrite, objectRead, (BoundingBox)intersection.get());
        }
    }

    private static void removeIntersectingVoxels(ObjectMask objectWrite, ObjectMask objectRead, BoundingBox intersection) {
        ObjectMask objectWriteDuplicated = objectWrite.duplicate();
        ObjectIntersectionRemover.assignOffVoxels(objectWrite, objectRead, intersection);
        ObjectIntersectionRemover.assignOffVoxels(objectRead, objectWriteDuplicated, intersection);
    }

    private static void assignOffVoxels(ObjectMask objectToAlter, ObjectMask object, BoundingBox restrictTo) {
        objectToAlter.assignOff().toObject(object, restrictTo);
    }

    private static void maybeErrorDisconnectedObjects(ObjectMask objectWrite, String description) throws OperationFailedException {
        if (!objectWrite.checkIfConnected()) {
            throw new OperationFailedException(String.format("Object %s becomes disconnected %s removing intersecting-pixels%n", objectWrite, description));
        }
    }

    @Generated
    private ObjectIntersectionRemover() {
    }
}

