/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge;

import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.graph.GraphWithPayload;
import org.anchoranalysis.core.graph.TypedEdge;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.plugin.image.object.merge.GraphLogger;
import org.anchoranalysis.plugin.image.object.merge.ObjectVertex;
import org.anchoranalysis.plugin.image.object.merge.condition.UpdatableBeforeCondition;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriority;
import org.anchoranalysis.plugin.image.object.merge.priority.PrioritisedVertex;

class NeighborGraph {
    private final UpdatableBeforeCondition beforeCondition;
    private final Optional<UnitConverter> unitConverter;
    private GraphWithPayload<ObjectVertex, PrioritisedVertex> graph = new GraphWithPayload(true);

    public void addVertex(ObjectVertex vertex, Collection<ObjectVertex> possibleNeighbors, AssignPriority prioritizer, GraphLogger logger) throws OperationFailedException {
        this.graph.addVertex((Object)vertex);
        this.beforeCondition.updateSourceObject(vertex.getObject(), this.unitConverter);
        for (ObjectVertex possibleNeighbor : possibleNeighbors) {
            this.maybeAddEdge(vertex, possibleNeighbor, prioritizer, logger);
        }
    }

    public Set<ObjectVertex> neighborNodesFor(TypedEdge<ObjectVertex, PrioritisedVertex> edge) {
        HashSet<ObjectVertex> setOut = new HashSet<ObjectVertex>();
        this.addNeighborsToSet((ObjectVertex)edge.getFrom(), setOut);
        this.addNeighborsToSet((ObjectVertex)edge.getTo(), setOut);
        setOut.remove(edge.getFrom());
        setOut.remove(edge.getTo());
        return setOut;
    }

    public ObjectCollection verticesAsObjects() {
        return ObjectCollectionFactory.mapFrom((Iterable)this.graph.vertices(), ObjectVertex::getObject);
    }

    public void removeVertex(ObjectVertex node) throws OperationFailedException {
        this.graph.removeVertex((Object)node);
    }

    int numberVertices() {
        return this.graph.numberVertices();
    }

    public Collection<TypedEdge<ObjectVertex, PrioritisedVertex>> edgeSetUnique() {
        return this.graph.edgesUnique();
    }

    Collection<ObjectVertex> vertexSet() {
        return this.graph.vertices();
    }

    private void addNeighborsToSet(ObjectVertex vertex, Set<ObjectVertex> setPossibleNeighbors) {
        for (TypedEdge edge : this.graph.outgoingEdgesFor((Object)vertex)) {
            if (!((ObjectVertex)edge.getFrom()).equals(vertex)) {
                setPossibleNeighbors.add((ObjectVertex)edge.getFrom());
            }
            if (((ObjectVertex)edge.getTo()).equals(vertex)) continue;
            setPossibleNeighbors.add((ObjectVertex)edge.getTo());
        }
    }

    private boolean maybeAddEdge(ObjectVertex from, ObjectVertex to, AssignPriority prioritizer, GraphLogger logger) throws OperationFailedException {
        if (!this.beforeCondition.accept(to.getObject())) {
            return false;
        }
        PrioritisedVertex withPriority = prioritizer.assignPriority(from, to, logger);
        this.graph.addEdge((Object)from, (Object)to, (Object)withPriority);
        return true;
    }

    @Generated
    public NeighborGraph(UpdatableBeforeCondition beforeCondition, Optional<UnitConverter> unitConverter) {
        this.beforeCondition = beforeCondition;
        this.unitConverter = unitConverter;
    }
}

