/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge.condition;

import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.object.merge.condition.AfterCondition;

public class IncreaseFeatureCondition
implements AfterCondition {
    private final FeatureEvaluator<FeatureInputSingleObject> featureEvaluator;
    private FeatureCalculatorSingle<FeatureInputSingleObject> session;

    @Override
    public void initialize(Logger logger) throws InitializeException {
        if (this.featureEvaluator != null) {
            try {
                this.session = this.featureEvaluator.createFeatureSession();
            }
            catch (OperationFailedException e) {
                throw new InitializeException((Throwable)e);
            }
        } else {
            this.session = null;
        }
    }

    @Override
    public boolean accept(ObjectMask source, ObjectMask destination, ObjectMask merged) throws OperationFailedException {
        if (this.session != null) {
            return this.doesIncreaseFeatureValueForBoth(source, destination, merged);
        }
        return true;
    }

    private boolean doesIncreaseFeatureValueForBoth(ObjectMask source, ObjectMask destination, ObjectMask merged) throws OperationFailedException {
        try {
            double featureSrc = this.calculate(source);
            double featureDest = this.calculate(destination);
            double featureMerge = this.calculate(merged);
            return featureMerge > featureSrc && featureMerge > featureDest;
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private double calculate(ObjectMask object) throws FeatureCalculationException {
        return this.session.calculate((FeatureInput)new FeatureInputSingleObject(object));
    }

    @Generated
    public IncreaseFeatureCondition(FeatureEvaluator<FeatureInputSingleObject> featureEvaluator) {
        this.featureEvaluator = featureEvaluator;
    }
}

