/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge.condition;

import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalDilation;
import org.anchoranalysis.plugin.image.object.merge.condition.GrowUtilities;
import org.anchoranalysis.plugin.image.object.merge.condition.UpdatableBeforeCondition;
import org.anchoranalysis.spatial.box.BoundingBox;

public class NeighborhoodCondition
implements UpdatableBeforeCondition {
    private boolean requireBBoxNeighbors;
    private boolean requireTouching;
    private BoundingBox boxSrcGrown;
    private ObjectMask objectGrown;

    public NeighborhoodCondition(boolean requireBBoxNeighbors, boolean requireTouching) {
        this.requireBBoxNeighbors = requireBBoxNeighbors;
        this.requireTouching = requireTouching;
        if (requireTouching) {
            this.requireBBoxNeighbors = false;
        }
    }

    @Override
    public void updateSourceObject(ObjectMask source, Optional<UnitConverter> unitConverter) throws OperationFailedException {
        this.boxSrcGrown = this.requireBBoxNeighbors ? NeighborhoodCondition.boundingBoxGrown(source) : null;
        try {
            this.objectGrown = this.requireTouching ? MorphologicalDilation.dilate((ObjectMask)source, Optional.empty(), (boolean)true, (int)1, (boolean)false) : null;
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    public boolean accept(ObjectMask destination) {
        if (this.requireBBoxNeighbors && !this.boxSrcGrown.intersection().existsWith(destination.boundingBox())) {
            return false;
        }
        return !this.requireTouching || this.objectGrown.hasIntersectingVoxels(destination);
    }

    private static BoundingBox boundingBoxGrown(ObjectMask object) {
        return GrowUtilities.grow(object.boundingBox());
    }
}

