/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.object.merge.priority;

import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.object.merge.ObjectVertex;
import org.anchoranalysis.plugin.image.object.merge.PayloadCalculator;
import org.anchoranalysis.plugin.image.object.merge.priority.AssignPriority;
import org.anchoranalysis.plugin.image.object.merge.priority.PrioritisedVertex;

public class AssignPriorityFromImprovement
extends AssignPriority {
    private final PayloadCalculator payloadCalculator;

    @Override
    public PrioritisedVertex assignPriorityToEdge(ObjectVertex source, ObjectVertex destination, ObjectMask merged, ErrorReporter errorReporter) throws OperationFailedException {
        double payloadMerge = this.calculatePayload(this.payloadCalculator, merged);
        double payloadExisting = AssignPriorityFromImprovement.weightedAverageFeatureVal(source, destination);
        double improvement = payloadMerge - payloadExisting;
        if (payloadMerge <= payloadExisting) {
            return new PrioritisedVertex(merged, payloadMerge, improvement, false);
        }
        return new PrioritisedVertex(merged, payloadMerge, improvement, true);
    }

    private double calculatePayload(PayloadCalculator payloadCalculator, ObjectMask object) throws OperationFailedException {
        try {
            return payloadCalculator.calculate(object);
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static double weightedAverageFeatureVal(ObjectVertex first, ObjectVertex second) {
        long size1 = first.numberVoxels();
        long size2 = second.numberVoxels();
        double weightedSum = first.getPayload() * (double)size1 + second.getPayload() * (double)size2;
        return weightedSum / (double)(size1 + size2);
    }

    @Generated
    public AssignPriorityFromImprovement(PayloadCalculator payloadCalculator) {
        this.payloadCalculator = payloadCalculator;
    }
}

