/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.watershed.encoding;

import lombok.Generated;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodedVoxels;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.WatershedEncoding;
import org.anchoranalysis.spatial.point.Point3i;

public final class EncodedIntBuffer {
    private final UnsignedIntBuffer delegate;
    private final WatershedEncoding encoding;

    public boolean isTemporary(int offset) {
        return this.delegate.getRaw(offset) == 1;
    }

    public boolean isUnvisited(int offset) {
        return this.delegate.getRaw(offset) == 0;
    }

    public boolean isMinima(int offset) {
        return this.delegate.getRaw(offset) == 2;
    }

    public boolean isConnectedComponentID(int offset) {
        return this.encoding.isConnectedComponentIDCode(this.delegate.getRaw(offset));
    }

    public void markAsTemporary(int offset) {
        this.delegate.putRaw(offset, 1);
    }

    public int getCode(int index) {
        return this.delegate.getRaw(index);
    }

    public void putCode(int index, int code) {
        this.delegate.putRaw(index, code);
    }

    public void convertCode(int indexBuffer, int indexGlobal, EncodedVoxels matS, Point3i point) {
        int currentValue = this.getCode(indexBuffer);
        assert (!matS.isPlateau(currentValue));
        assert (!matS.isUnvisited(currentValue));
        assert (!matS.isTemporary(currentValue));
        if (matS.isMinima(currentValue)) {
            this.putConnectedComponentID(indexBuffer, indexGlobal);
        } else if (!matS.isConnectedComponentIDCode(currentValue)) {
            int finalIndex = matS.calculateConnectedComponentID(point, currentValue);
            this.putCode(indexBuffer, finalIndex);
        }
    }

    private void putConnectedComponentID(int index, int connectedComponentID) {
        int encoded = this.encoding.encodeConnectedComponentID(connectedComponentID);
        this.delegate.putRaw(index, encoded);
    }

    @Generated
    public EncodedIntBuffer(UnsignedIntBuffer delegate, WatershedEncoding encoding) {
        this.delegate = delegate;
        this.encoding = encoding;
    }
}

