/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.watershed.encoding;

import java.util.Optional;
import org.anchoranalysis.image.voxel.buffer.SlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.IterateVoxelsNeighbors;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighbor;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsolute;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborAbsoluteWithSlidingBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.ProcessVoxelNeighborFactory;
import org.anchoranalysis.image.voxel.neighborhood.Neighborhood;
import org.anchoranalysis.image.voxel.neighborhood.NeighborhoodFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.WatershedEncoding;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;

public final class Steepest {
    private final boolean do3D;
    private final ProcessVoxelNeighbor<Integer> process;
    private final Neighborhood neighborhood;

    public Steepest(SlidingBuffer<?> buffer, WatershedEncoding encoder, boolean do3D, boolean bigNeighborhood, Optional<ObjectMask> objectMask) {
        this.do3D = do3D;
        this.process = ProcessVoxelNeighborFactory.within(objectMask, (Extent)buffer.extent(), (ProcessVoxelNeighborAbsolute)new PointEvaluator(encoder, buffer));
        this.neighborhood = NeighborhoodFactory.of((boolean)bigNeighborhood);
    }

    public int steepestDescent(Point3i point, int val, int indxBuffer) {
        return (Integer)IterateVoxelsNeighbors.callEachPointInNeighborhood((Point3i)point, (Neighborhood)this.neighborhood, (boolean)this.do3D, this.process, (int)val, (int)indxBuffer);
    }

    private static class PointEvaluator
    extends ProcessVoxelNeighborAbsoluteWithSlidingBuffer<Integer> {
        private final WatershedEncoding encoder;
        private int direction;
        private int value;

        public PointEvaluator(WatershedEncoding encoder, SlidingBuffer<?> buffer) {
            super(buffer);
            this.encoder = encoder;
        }

        public void initSource(int sourceValue, int sourceOffsetXY) {
            super.initSource(sourceValue, sourceOffsetXY);
            this.value = sourceValue;
            this.direction = 2;
        }

        public void processPoint(int xChange, int yChange, int x1, int y1) {
            int gValNeighborhood = this.getInt(xChange, yChange);
            if (gValNeighborhood == this.sourceValue) {
                this.direction = 3;
            }
            if (gValNeighborhood < this.value) {
                this.value = gValNeighborhood;
                this.direction = this.encoder.encodeDirection(xChange, yChange, this.zChange);
            }
        }

        public Integer collectResult() {
            return this.direction;
        }
    }
}

