/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.segment.watershed.encoding;

import org.anchoranalysis.plugin.image.segment.watershed.encoding.ChainCodesDirection;
import org.anchoranalysis.plugin.image.segment.watershed.encoding.EncodeDirection;
import org.anchoranalysis.spatial.point.Point3i;

public class WatershedEncoding
implements EncodeDirection {
    public static final int CODE_UNVISITED = 0;
    public static final int CODE_TEMPORARY = 1;
    public static final int CODE_MINIMA = 2;
    public static final int CODE_PLATEAU = 3;
    private static final int START_CHAIN_CODE_RANGE = 4;
    private static final int END_CHAIN_CODE_RANGE = 31;

    @Override
    public int encodeDirection(int x, int y, int z) {
        return ChainCodesDirection.chainCode(x, y, z) + 4;
    }

    public Point3i chainCodes(int chainCode) {
        return ChainCodesDirection.decode(chainCode - 4);
    }

    public int encodeConnectedComponentID(int connectedComponentID) {
        return connectedComponentID + 31;
    }

    public boolean isDirectionChainCode(int code) {
        return code >= 4 && code < 31;
    }

    public boolean isConnectedComponentIDCode(int code) {
        return code >= 31;
    }

    public int decodeConnectedComponentID(int code) {
        return code - 31;
    }
}

