/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.blur;

import com.google.common.base.Preconditions;
import lombok.Generated;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.gauss3.Gauss3;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;

class GaussianBlurUtilities {
    public static <T extends NumericType<T>> void applyBlur(Img<? extends RealType<?>> img, double[] sigma) {
        Preconditions.checkArgument((sigma.length == 3 ? 1 : 0) != 0);
        Img<? extends RealType<?>> imgCast = img;
        Gauss3.gauss((double[])sigma, (RandomAccessible)Views.extendMirrorSingle(imgCast), imgCast);
    }

    @Generated
    private GaussianBlurUtilities() {
    }
}

