/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.aggregator;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.channel.ChannelAggregator;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.spatial.box.Extent;

public abstract class ProjectableBufferAggregator<T>
extends ChannelAggregator {
    private ProjectableBuffer<T> projection;
    private Dimensions dimensions;

    protected Optional<Dimensions> existingDimensions() {
        return Optional.ofNullable(this.maybeDropResolution(this.dimensions));
    }

    protected void addChannelAfterCheck(Channel channel) throws OperationFailedException {
        this.createProjectionIfNeeded(channel.dimensions(), channel.getVoxelDataType());
        this.projection.addVoxels(channel.voxels().any());
    }

    protected Channel retrieveCreateAggregatedChannel() {
        return ChannelFactory.instance().create(this.projection.completeProjection());
    }

    protected abstract ProjectableBuffer<T> create(VoxelDataType var1, Extent var2) throws OperationFailedException;

    private void createProjectionIfNeeded(Dimensions dimensions, VoxelDataType dataType) throws OperationFailedException {
        if (this.projection == null) {
            this.projection = this.create(dataType, dimensions.extent());
            this.dimensions = dimensions;
        }
    }

    @Generated
    public ProjectableBufferAggregator() {
    }
}

