/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.convert;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.OptionalUtilities;
import org.anchoranalysis.image.bean.channel.ConvertChannelToWithHistogram;
import org.anchoranalysis.image.bean.provider.HistogramProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.convert.attached.ChannelConverterAttached;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.statistics.HistogramFactory;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.bean.channel.provider.convert.ConvertBase;

public class ConvertWithHistogram<T>
extends ConvertBase {
    @BeanField
    private ConvertChannelToWithHistogram<T> convert;
    @BeanField
    @OptionalBean
    private HistogramProvider histogram;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        ChannelConverterAttached converter = this.convert.createConverter();
        try {
            converter.attachObject((Object)this.createHistogram(channel));
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
        return converter.convert(channel, this.createPolicy());
    }

    private Histogram createHistogram(Channel channel) throws ProvisionFailedException {
        return (Histogram)OptionalUtilities.orElseGet((Optional)OptionalProviderFactory.create((Provider)this.histogram), () -> HistogramFactory.createFrom((VoxelsUntyped)channel.voxels()));
    }

    @Generated
    public ConvertChannelToWithHistogram<T> getConvert() {
        return this.convert;
    }

    @Generated
    public void setConvert(ConvertChannelToWithHistogram<T> convert) {
        this.convert = convert;
    }

    @Generated
    public HistogramProvider getHistogram() {
        return this.histogram;
    }

    @Generated
    public void setHistogram(HistogramProvider histogram) {
        this.histogram = histogram;
    }
}

