/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.gradient;

import net.imglib2.Cursor;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.outofbounds.OutOfBounds;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.Views;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.convert.imglib2.ConvertToNativeImg;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.image.bean.channel.provider.gradient.GradientBase;

public class Sobel
extends GradientBase {
    public Channel createFromChannel(Channel channelIn) throws ProvisionFailedException {
        Channel intermediate = Sobel.createNewFloat(channelIn.dimensions());
        try {
            this.processMultiplexInputType(channelIn, (NativeImg<FloatType, FloatArray>)ConvertToNativeImg.fromFloat((Voxels)intermediate.voxels().asFloat()));
        }
        catch (CreateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
        return this.convertToOutputType(intermediate);
    }

    private void processMultiplexInputType(Channel channelIn, NativeImg<FloatType, FloatArray> out) throws CreateException {
        if (channelIn.getVoxelDataType().equals((Object)UnsignedByteVoxelType.INSTANCE)) {
            Sobel.process(ConvertToNativeImg.fromByte((Voxels)channelIn.voxels().asByte()), out, (float)this.getScaleFactor());
        } else if (channelIn.getVoxelDataType().equals((Object)UnsignedShortVoxelType.INSTANCE)) {
            Sobel.process(ConvertToNativeImg.fromShort((Voxels)channelIn.voxels().asShort()), out, (float)this.getScaleFactor());
        } else {
            throw new CreateException("Input type must be unsigned byte or short");
        }
    }

    private static <T extends RealType<T>> void process(NativeImg<T, ?> input, NativeImg<FloatType, FloatArray> output, float scaleFactor) {
        Cursor in = input.localizingCursor();
        RandomAccess oc = output.randomAccess();
        OutOfBounds ra = Views.extendMirrorDouble(input).randomAccess();
        float[][] kernel = new float[3][3];
        while (in.hasNext()) {
            in.fwd();
            ra.setPosition((Localizable)in);
            for (int i = 0; i < input.numDimensions(); ++i) {
                oc.setPosition(in.getLongPosition(i), i);
            }
            ra.bck(0);
            Sobel.readPointInto(ra, kernel, 0);
            ra.fwd(0);
            Sobel.readPointInto(ra, kernel, 1);
            ra.fwd(0);
            Sobel.readPointInto(ra, kernel, 2);
            ra.bck(0);
            ((FloatType)oc.get()).set(Sobel.normedSobelOnKernel(kernel) * scaleFactor);
        }
    }

    private static <T extends RealType<T>> void readPointInto(OutOfBounds<T> ra, float[][] kernel, int kernelIndex) {
        ra.bck(1);
        kernel[kernelIndex][0] = ((RealType)ra.get()).getRealFloat();
        ra.fwd(1);
        kernel[kernelIndex][1] = ((RealType)ra.get()).getRealFloat();
        ra.fwd(1);
        kernel[kernelIndex][2] = ((RealType)ra.get()).getRealFloat();
        ra.bck(1);
    }

    private static float normedSobelOnKernel(float[][] kernel) {
        float gx = -1.0f * kernel[0][0] - 2.0f * kernel[0][1] - 1.0f * kernel[0][2] + 1.0f * kernel[2][0] + 2.0f * kernel[2][1] + 1.0f * kernel[2][2];
        float gy = -1.0f * kernel[0][0] - 2.0f * kernel[1][0] - 1.0f * kernel[2][0] + 1.0f * kernel[0][2] + 2.0f * kernel[1][2] + 1.0f * kernel[2][2];
        return (float)Math.sqrt(Math.pow(gx, 2.0) + Math.pow(gy, 2.0));
    }

    private static Channel createNewFloat(Dimensions dimensions) {
        return ChannelFactory.instance().create(dimensions, (VoxelDataType)FloatVoxelType.INSTANCE);
    }
}

