/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.intensity;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.datatype.CombineTypes;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.image.channel.DimensionsChecker;

public class IfVoxelZero
extends ChannelProviderUnary {
    @BeanField
    private ChannelProvider channelIfVoxelZero;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        try {
            Channel ifZero = DimensionsChecker.createSameSize(this.channelIfVoxelZero, "channelIfVoxelZero", channel);
            VoxelDataType combinedType = CombineTypes.combineTypes((VoxelDataType)channel.getVoxelDataType(), (VoxelDataType)ifZero.getVoxelDataType());
            double multFact = (double)combinedType.maxValue() / (double)channel.getVoxelDataType().maxValue();
            return IfVoxelZero.mergeViaZeroCheck(channel, ifZero, combinedType, multFact);
        }
        catch (CreateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    public static Channel mergeViaZeroCheck(Channel channel, Channel channelIfPixelZero, VoxelDataType combinedType, double multiplierIfNonZero) {
        Channel channelOut = ChannelFactory.instance().create(channel.dimensions(), combinedType);
        IfVoxelZero.processVoxels(channelOut.voxels(), channel.voxels(), channelIfPixelZero.voxels(), multiplierIfNonZero);
        return channelOut;
    }

    private static void processVoxels(VoxelsUntyped voxelsOut, VoxelsUntyped voxelsIn, VoxelsUntyped voxelsIfZero, double multFactorIfNonZero) {
        int volumeXY = voxelsIn.extent().areaXY();
        for (int z = 0; z < voxelsOut.extent().z(); ++z) {
            VoxelBuffer in1 = voxelsIn.slice(z);
            VoxelBuffer in2 = voxelsIfZero.slice(z);
            VoxelBuffer out = voxelsOut.slice(z);
            for (int offset = 0; offset < volumeXY; ++offset) {
                int b1 = in1.getInt(offset);
                if (b1 != 0) {
                    out.putInt(offset, (int)((double)b1 * multFactorIfNonZero));
                    continue;
                }
                int b2 = in2.getInt(offset);
                out.putInt(offset, b2);
            }
        }
    }

    @Generated
    public ChannelProvider getChannelIfVoxelZero() {
        return this.channelIfVoxelZero;
    }

    @Generated
    public void setChannelIfVoxelZero(ChannelProvider channelIfVoxelZero) {
        this.channelIfVoxelZero = channelIfVoxelZero;
    }
}

