/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.intensity;

import com.google.common.collect.BoundType;
import com.google.common.collect.TreeMultiset;
import java.util.Iterator;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.spatial.box.Extent;

public class Median
extends ChannelProviderUnary {
    @BeanField
    private int kernelHalfWidth;

    public Channel createFromChannel(Channel channel) throws ProvisionFailedException {
        Voxels voxels = channel.voxels().asByte();
        RollingMultiSet set = new RollingMultiSet(this.kernelHalfWidth);
        Channel dup = channel.duplicate();
        Voxels voxelsDup = dup.voxels().asByte();
        Extent extent = dup.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedByteBuffer buffer = (UnsignedByteBuffer)voxels.sliceBuffer(z);
            UnsignedByteBuffer bufferOut = (UnsignedByteBuffer)voxelsDup.sliceBuffer(z);
            int offset = 0;
            for (int y = 0; y < extent.y(); ++y) {
                int yMin = y - this.kernelHalfWidth;
                int yMax = y + this.kernelHalfWidth;
                yMin = Math.max(yMin, 0);
                yMax = Math.min(yMax, extent.y() - 1);
                for (int x = 0; x < extent.x(); ++x) {
                    if (x == 0) {
                        set.clear();
                        set.populateAt(x, yMin, yMax, buffer, extent);
                    } else {
                        set.removeColumn(x - this.kernelHalfWidth - 1, yMin, yMax, buffer, extent);
                        set.addColumn(x + this.kernelHalfWidth, yMin, yMax, buffer, extent);
                    }
                    int median = set.median();
                    bufferOut.putUnsigned(offset, median);
                    ++offset;
                }
            }
        }
        return dup;
    }

    @Generated
    public int getKernelHalfWidth() {
        return this.kernelHalfWidth;
    }

    @Generated
    public void setKernelHalfWidth(int kernelHalfWidth) {
        this.kernelHalfWidth = kernelHalfWidth;
    }

    private static class RollingMultiSet {
        private final int kernelHalfWidth;
        private TreeMultiset<Integer> set = TreeMultiset.create();

        public void clear() {
            this.set.clear();
        }

        public void populateAt(int xCenter, int yMin, int yMax, UnsignedByteBuffer buffer, Extent extent) {
            int xMin = xCenter - this.kernelHalfWidth;
            int xMax = xCenter + this.kernelHalfWidth;
            xMin = Math.max(xMin, 0);
            xMax = Math.min(xMax, extent.x() - 1);
            for (int y = yMin; y <= yMax; ++y) {
                for (int x = xMin; x <= xMax; ++x) {
                    this.set.add((Object)buffer.getUnsigned(extent.offset(x, y)));
                }
            }
        }

        public void removeColumn(int x, int yMin, int yMax, UnsignedByteBuffer buffer, Extent e) {
            if (x < 0) {
                return;
            }
            if (x >= e.x()) {
                return;
            }
            for (int y = yMin; y <= yMax; ++y) {
                int value = buffer.getUnsigned(e.offset(x, y));
                assert (this.set.contains((Object)value));
                this.set.remove((Object)value);
            }
        }

        public void addColumn(int x, int yMin, int yMax, UnsignedByteBuffer buffer, Extent extent) {
            if (x < 0) {
                return;
            }
            if (x >= extent.x()) {
                return;
            }
            for (int y = yMin; y <= yMax; ++y) {
                int offset = extent.offset(x, y);
                this.set.add((Object)buffer.getUnsigned(offset));
            }
        }

        public int median() {
            int size = this.size();
            int medianIndex = size / 2;
            Iterator itr = this.set.headMultiset((Object)255, BoundType.CLOSED).iterator();
            for (int i = 1; i < medianIndex; ++i) {
                itr.next();
            }
            return (Integer)itr.next();
        }

        public int size() {
            return this.set.headMultiset((Object)255, BoundType.CLOSED).size();
        }

        @Generated
        public RollingMultiSet(int kernelHalfWidth) {
            this.kernelHalfWidth = kernelHalfWidth;
        }
    }
}

