/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.intensity;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMask;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.bean.channel.provider.UnaryWithObjectsBase;
import org.anchoranalysis.plugin.image.channel.DimensionsChecker;

public class NormalizeDifferenceToMedian
extends UnaryWithObjectsBase {
    @BeanField
    private ChannelProvider channelLookup;

    @Override
    protected Channel createFromChannel(Channel channel, ObjectCollection objects) throws ProvisionFailedException {
        Channel lookup = DimensionsChecker.createSameSize(this.channelLookup, "channelLookup", channel);
        try {
            for (ObjectMask object : objects) {
                Histogram histogram = HistogramFromObjectsFactory.createFrom((VoxelsUntyped)lookup.voxels(), Optional.of(object));
                this.adjustObject(object, channel, lookup, (int)Math.round(histogram.mean()));
            }
            return channel;
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException("An error occurred calculating the mean", (Throwable)e);
        }
    }

    private void adjustObject(ObjectMask object, Channel channel, Channel channelLookup, int medianFromObject) {
        IterateVoxelsObjectMask.withTwoBuffers((ObjectMask)object, (Voxels)channel.voxels().asByte(), (Voxels)channelLookup.voxels().asByte(), (point, buffer, bufferLookup, offset, offsetLookup) -> {
            int valueToAssign = NormalizeDifferenceToMedian.clampValue(buffer.getUnsigned(offset) - medianFromObject + bufferLookup.getUnsigned(offsetLookup));
            buffer.putUnsigned(offset, valueToAssign);
        });
    }

    private static int clampValue(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 255) {
            return 255;
        }
        return value;
    }

    @Generated
    public ChannelProvider getChannelLookup() {
        return this.channelLookup;
    }

    @Generated
    public void setChannelLookup(ChannelProvider channelLookup) {
        this.channelLookup = channelLookup;
    }
}

