/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.intensity;

import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.channel.provider.UnaryWithObjectsBase;
import org.anchoranalysis.plugin.image.intensity.IntensityMeanCalculator;

public class NormalizeObjectIntensity
extends UnaryWithObjectsBase {
    @Override
    protected Channel createFromChannel(Channel channel, ObjectCollection objects) throws ProvisionFailedException {
        Voxels voxels = channel.voxels().any();
        for (ObjectMask object : objects) {
            try {
                double meanIntensity = IntensityMeanCalculator.calculateMeanIntensityObject(channel, object);
                if (meanIntensity == 0.0) {
                    voxels.assignValue(128).toObject(object);
                    continue;
                }
                double scaleFactor = 128.0 / meanIntensity;
                voxels.arithmetic().multiplyBy(object, scaleFactor);
            }
            catch (FeatureCalculationException e) {
                throw new ProvisionFailedException((Throwable)e);
            }
        }
        return channel;
    }
}

