/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.graph.GraphWithPayload;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.neighborhood.NeighborGraph;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.bean.channel.provider.object.LevelPerObjectBase;
import org.anchoranalysis.plugin.image.bean.channel.provider.object.ObjectWithHistogram;
import org.anchoranalysis.spatial.box.Extent;

public class LevelPerObjectNeighbors
extends LevelPerObjectBase {
    @BeanField
    @Positive
    private int distance;

    @Override
    protected void writeLevelsForObjects(Channel channelIntensity, ObjectCollection objects, Channel output) throws ProvisionFailedException {
        try {
            this.setAgainstNeighbor(channelIntensity, output, objects, this.distance);
        }
        catch (OperationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static void visit(GraphWithPayload<ObjectWithHistogram, Integer> graph, List<ObjectWithHistogram> currentVisit, List<ObjectWithHistogram> toVisit, Set<ObjectWithHistogram> visited) {
        for (ObjectWithHistogram omLocal : currentVisit) {
            List adjacentObjects = graph.adjacentVerticesOutgoing((Object)omLocal);
            for (ObjectWithHistogram object : adjacentObjects) {
                if (visited.contains(object)) continue;
                toVisit.add(object);
            }
            visited.add(omLocal);
        }
    }

    private static Collection<ObjectWithHistogram> verticesWithinDistance(GraphWithPayload<ObjectWithHistogram, Integer> graph, ObjectWithHistogram om, int neighborDistance) {
        if (neighborDistance == 1) {
            return graph.adjacentVerticesOutgoing((Object)om);
        }
        HashSet<ObjectWithHistogram> visited = new HashSet<ObjectWithHistogram>();
        ArrayList<ObjectWithHistogram> toVisit = new ArrayList<ObjectWithHistogram>();
        toVisit.add(om);
        for (int i = 0; i < neighborDistance; ++i) {
            ArrayList<ObjectWithHistogram> currentVisit = toVisit;
            toVisit = new ArrayList();
            LevelPerObjectNeighbors.visit(graph, currentVisit, toVisit, visited);
        }
        return visited;
    }

    private static Histogram createSumHistograms(Histogram histogram, Collection<Histogram> others) throws OperationFailedException {
        Histogram out = histogram.duplicate();
        for (Histogram other : others) {
            out.addHistogram(other);
        }
        return out;
    }

    private void setAgainstNeighbor(Channel channelIntensity, Channel channelOutput, ObjectCollection objects, int neighborDistance) throws OperationFailedException {
        try {
            GraphWithPayload graph = NeighborGraph.create(LevelPerObjectNeighbors.objectsWithHistograms(objects, channelIntensity), ObjectWithHistogram::getObject, (Extent)channelIntensity.extent(), (boolean)false, (boolean)true);
            Voxels voxelsOutput = channelOutput.voxels().any();
            HashMap<ObjectWithHistogram, Integer> mapLevel = new HashMap<ObjectWithHistogram, Integer>();
            for (ObjectWithHistogram om : graph.vertices()) {
                this.getLogger().messageLogger().logFormatted("Setting for %s against neighborhood", new Object[]{om.getObject().centerOfGravity()});
                Collection<ObjectWithHistogram> vertexNeighbors = LevelPerObjectNeighbors.verticesWithinDistance((GraphWithPayload<ObjectWithHistogram, Integer>)graph, om, neighborDistance);
                for (ObjectWithHistogram neighbor : vertexNeighbors) {
                    this.getLogger().messageLogger().logFormatted("Including neighbor %s", new Object[]{neighbor.getObject().centerOfGravity()});
                }
                int level = this.calculateLevelCombinedHist(om, vertexNeighbors);
                voxelsOutput.assignValue(level).toObject(om.getObject());
                this.getLogger().messageLogger().logFormatted("Setting threshold %d at %s", new Object[]{level, om.getObject().centerOfGravity()});
                mapLevel.put(om, level);
            }
        }
        catch (CreateException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    private static List<ObjectWithHistogram> objectsWithHistograms(ObjectCollection objects, Channel channelIntensity) {
        return objects.stream().mapToList(objectMask -> new ObjectWithHistogram((ObjectMask)objectMask, channelIntensity));
    }

    private int calculateLevelCombinedHist(ObjectWithHistogram objectMask, Collection<ObjectWithHistogram> vertices) throws OperationFailedException {
        List histogramsFromVertices = FunctionalList.mapToList(vertices, ObjectWithHistogram::getHistogram);
        return this.getCalculateLevel().calculateLevel(LevelPerObjectNeighbors.createSumHistograms(objectMask.getHistogram(), histogramsFromVertices));
    }

    @Generated
    public int getDistance() {
        return this.distance;
    }

    @Generated
    public void setDistance(int distance) {
        this.distance = distance;
    }
}

