/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.score;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.functional.checked.CheckedToIntFunction;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.energy.EnergyStackWithoutParameters;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.channel.provider.UnaryWithObjectsBase;

public class ScoreObjects
extends UnaryWithObjectsBase {
    @BeanField
    private int valueNoObject = 0;
    @BeanField
    @SkipInit
    private Feature<FeatureInputSingleObject> feature;
    @BeanField
    private List<ChannelProvider> listAdditionalChannelProviders = new ArrayList<ChannelProvider>();
    @BeanField
    private double factor = 1.0;

    @Override
    protected Channel createFromChannel(Channel channel, ObjectCollection objects) throws ProvisionFailedException {
        try {
            EnergyStack energyStack = new EnergyStack(this.createEnergyStack(channel));
            FeatureCalculatorSingle<FeatureInputSingleObject> calculator = this.createSession(this.feature);
            return this.createOutputChannel(channel.dimensions(), objects, (CheckedToIntFunction<ObjectMask, FeatureCalculationException>)((CheckedToIntFunction)object -> this.valueToAssignForObject((ObjectMask)object, calculator, energyStack)));
        }
        catch (InitializeException | FeatureCalculationException e) {
            throw new ProvisionFailedException(e);
        }
    }

    private EnergyStackWithoutParameters createEnergyStack(Channel channel) throws ProvisionFailedException {
        EnergyStackWithoutParameters energyStack = new EnergyStackWithoutParameters(channel);
        for (ChannelProvider cp : this.listAdditionalChannelProviders) {
            Channel channelAdditional = (Channel)cp.get();
            if (!channelAdditional.dimensions().equals((Object)channel.dimensions())) {
                throw new ProvisionFailedException("Dimensions of additional channel are not equal to main channel");
            }
            try {
                energyStack.asStack().addChannel(channelAdditional);
            }
            catch (IncorrectImageSizeException e) {
                throw new ProvisionFailedException((Throwable)e);
            }
        }
        return energyStack;
    }

    private FeatureCalculatorSingle<FeatureInputSingleObject> createSession(Feature<FeatureInputSingleObject> feature) throws InitializeException {
        return FeatureSession.with(feature, (FeatureInitialization)new FeatureInitialization(), (SharedFeatures)((ImageInitialization)this.getInitialization()).featuresInitialization().getSharedFeatures(), (Logger)this.getLogger());
    }

    private Channel createOutputChannel(Dimensions dimensions, ObjectCollection objectsSource, CheckedToIntFunction<ObjectMask, FeatureCalculationException> valueToAssign) throws FeatureCalculationException {
        Channel out = ChannelFactory.instance().create(dimensions, (VoxelDataType)UnsignedByteVoxelType.INSTANCE);
        out.assignValue(this.valueNoObject).toAll();
        for (ObjectMask object : objectsSource) {
            out.assignValue(valueToAssign.applyAsInt((Object)object)).toObject(object);
        }
        return out;
    }

    private int valueToAssignForObject(ObjectMask object, FeatureCalculatorSingle<FeatureInputSingleObject> calculator, EnergyStack energyStack) throws FeatureCalculationException {
        double featVal = calculator.calculate((FeatureInput)new FeatureInputSingleObject(object, energyStack));
        return (int)(this.factor * featVal);
    }

    @Generated
    public int getValueNoObject() {
        return this.valueNoObject;
    }

    @Generated
    public void setValueNoObject(int valueNoObject) {
        this.valueNoObject = valueNoObject;
    }

    @Generated
    public Feature<FeatureInputSingleObject> getFeature() {
        return this.feature;
    }

    @Generated
    public void setFeature(Feature<FeatureInputSingleObject> feature) {
        this.feature = feature;
    }

    @Generated
    public List<ChannelProvider> getListAdditionalChannelProviders() {
        return this.listAdditionalChannelProviders;
    }

    @Generated
    public void setListAdditionalChannelProviders(List<ChannelProvider> listAdditionalChannelProviders) {
        this.listAdditionalChannelProviders = listAdditionalChannelProviders;
    }

    @Generated
    public double getFactor() {
        return this.factor;
    }

    @Generated
    public void setFactor(double factor) {
        this.factor = factor;
    }
}

