/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.score;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.bean.provider.HistogramProvider;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.feature.bean.VoxelScore;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.bean.channel.provider.score.ProviderBeanHelper;
import org.anchoranalysis.plugin.image.bean.channel.provider.score.VoxelsFromScoreCreator;
import org.anchoranalysis.plugin.image.bean.channel.provider.score.VoxelsWrapperList;
import org.anchoranalysis.spatial.box.BoundingBox;

public class ScoreVoxels
extends ChannelProvider {
    @BeanField
    private ChannelProvider intensity;
    @BeanField
    @OptionalBean
    private ChannelProvider gradient;
    @BeanField
    @OptionalBean
    private MaskProvider mask;
    @BeanField
    private VoxelScore score;
    @BeanField
    private List<ChannelProvider> channelsExtra = Arrays.asList(new ChannelProvider[0]);
    @BeanField
    private List<HistogramProvider> histogramsExtra = Arrays.asList(new HistogramProvider[0]);
    @BeanField
    @OptionalBean
    private DictionaryProvider dictionary;

    public Channel get() throws ProvisionFailedException {
        Channel intensityCreated = (Channel)this.intensity.get();
        VoxelsWrapperList voxelsCreated = this.createVoxelsList(intensityCreated);
        List<Histogram> histogramsCreated = ProviderBeanHelper.listFromBeans(this.histogramsExtra);
        Optional dictionaryCreated = OptionalProviderFactory.create((Provider)this.dictionary);
        Optional<ObjectMask> object = this.createObject();
        VoxelsFromScoreCreator creator = new VoxelsFromScoreCreator(voxelsCreated, dictionaryCreated, histogramsCreated);
        try {
            Voxels<UnsignedByteBuffer> voxelsPixelScore = creator.createVoxelsFromPixelScore(this.score, object);
            return new ChannelFactoryUnsignedByte().create(voxelsPixelScore, intensityCreated.resolution());
        }
        catch (CreateException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private VoxelsWrapperList createVoxelsList(Channel channelIntensity) throws ProvisionFailedException {
        VoxelsWrapperList out = new VoxelsWrapperList();
        out.add(channelIntensity.voxels());
        OptionalProviderFactory.create((Provider)this.gradient).map(Channel::voxels).ifPresent(out::add);
        for (ChannelProvider channelProvider : this.channelsExtra) {
            VoxelsUntyped voxelsExtra = channelProvider != null ? ((Channel)channelProvider.get()).voxels() : null;
            out.add(voxelsExtra);
        }
        return out;
    }

    private Optional<ObjectMask> createObject() throws ProvisionFailedException {
        if (this.mask == null) {
            return Optional.empty();
        }
        Mask createdMask = (Mask)this.mask.get();
        Channel channelMask = createdMask.channel();
        return Optional.of(new ObjectMask(new BoundingBox(channelMask.extent()), channelMask.voxels().asByte(), createdMask.binaryValuesInt()));
    }

    @Generated
    public ChannelProvider getIntensity() {
        return this.intensity;
    }

    @Generated
    public void setIntensity(ChannelProvider intensity) {
        this.intensity = intensity;
    }

    @Generated
    public ChannelProvider getGradient() {
        return this.gradient;
    }

    @Generated
    public void setGradient(ChannelProvider gradient) {
        this.gradient = gradient;
    }

    @Generated
    public MaskProvider getMask() {
        return this.mask;
    }

    @Generated
    public void setMask(MaskProvider mask) {
        this.mask = mask;
    }

    @Generated
    public VoxelScore getScore() {
        return this.score;
    }

    @Generated
    public void setScore(VoxelScore score) {
        this.score = score;
    }

    @Generated
    public List<ChannelProvider> getChannelsExtra() {
        return this.channelsExtra;
    }

    @Generated
    public void setChannelsExtra(List<ChannelProvider> channelsExtra) {
        this.channelsExtra = channelsExtra;
    }

    @Generated
    public List<HistogramProvider> getHistogramsExtra() {
        return this.histogramsExtra;
    }

    @Generated
    public void setHistogramsExtra(List<HistogramProvider> histogramsExtra) {
        this.histogramsExtra = histogramsExtra;
    }

    @Generated
    public DictionaryProvider getDictionary() {
        return this.dictionary;
    }

    @Generated
    public void setDictionary(DictionaryProvider dictionary) {
        this.dictionary = dictionary;
    }
}

