/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.score;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.feature.bean.VoxelScore;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.plugin.image.bean.channel.provider.score.BufferUtilities;
import org.anchoranalysis.plugin.image.bean.channel.provider.score.VoxelsWrapperList;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class VoxelsFromScoreCreator {
    private VoxelsWrapperList listVoxels;
    private Optional<Dictionary> dictionary;
    private List<Histogram> listAdditionalHistograms;

    public Voxels<UnsignedByteBuffer> createVoxelsFromPixelScore(VoxelScore pixelScore, Optional<ObjectMask> object) throws CreateException {
        try {
            this.initialize(pixelScore, object);
            Extent extent = this.listVoxels.getFirstExtent();
            Voxels voxelsOut = VoxelsFactory.getUnsignedByte().createInitialized(extent);
            if (object.isPresent()) {
                this.setVoxelsWithMask((Voxels<UnsignedByteBuffer>)voxelsOut, object.get(), pixelScore);
            } else {
                this.setVoxelsWithoutMask((Voxels<UnsignedByteBuffer>)voxelsOut, pixelScore);
            }
            return voxelsOut;
        }
        catch (InitializeException | FeatureCalculationException e) {
            throw new CreateException(e);
        }
    }

    private void initialize(VoxelScore pixelScore, Optional<ObjectMask> object) throws InitializeException {
        pixelScore.initialize(this.createHistograms(object), this.dictionary);
    }

    private List<Histogram> createHistograms(Optional<ObjectMask> object) {
        ArrayList<Histogram> out = new ArrayList<Histogram>();
        for (VoxelsUntyped voxels : this.listVoxels) {
            out.add(HistogramFromObjectsFactory.createFrom((VoxelsUntyped)voxels, object));
        }
        for (Histogram histogram : this.listAdditionalHistograms) {
            out.add(histogram);
        }
        return out;
    }

    private void setVoxelsWithoutMask(Voxels<UnsignedByteBuffer> voxelsOut, VoxelScore pixelScore) throws FeatureCalculationException {
        Extent extent = voxelsOut.extent();
        for (int z = 0; z < extent.z(); ++z) {
            List bufferList = this.listVoxels.bufferListForSlice(z);
            UnsignedByteBuffer bufferOut = (UnsignedByteBuffer)voxelsOut.sliceBuffer(z);
            for (int y = 0; y < extent.y(); ++y) {
                for (int x = 0; x < extent.x(); ++x) {
                    int offset = extent.offset(x, y);
                    BufferUtilities.putScoreForOffset(pixelScore, bufferList, bufferOut, offset);
                }
            }
        }
    }

    private void setVoxelsWithMask(Voxels<UnsignedByteBuffer> voxelsOut, ObjectMask object, VoxelScore pixelScore) throws FeatureCalculationException {
        byte maskOn = object.binaryValuesByte().getOn();
        Extent e = voxelsOut.extent();
        Extent eMask = object.binaryVoxels().extent();
        ReadableTuple3i cornerMin = object.boundingBox().cornerMin();
        ReadableTuple3i cornerMax = object.boundingBox().calculateCornerMaxInclusive();
        for (int z = cornerMin.z(); z <= cornerMax.z(); ++z) {
            List bufferList = this.listVoxels.bufferListForSlice(z);
            int zRel = z - cornerMin.z();
            UnsignedByteBuffer bufferMask = object.sliceBufferLocal(zRel);
            UnsignedByteBuffer bufferOut = (UnsignedByteBuffer)voxelsOut.sliceBuffer(z);
            for (int y = cornerMin.y(); y <= cornerMax.y(); ++y) {
                for (int x = cornerMin.x(); x <= cornerMax.x(); ++x) {
                    int offset = e.offset(x, y);
                    int offsetMask = eMask.offset(x - cornerMin.x(), y - cornerMin.y());
                    if (bufferMask.getRaw(offsetMask) != maskOn) continue;
                    BufferUtilities.putScoreForOffset(pixelScore, bufferList, bufferOut, offset);
                }
            }
        }
    }

    @Generated
    public VoxelsFromScoreCreator(VoxelsWrapperList listVoxels, Optional<Dictionary> dictionary, List<Histogram> listAdditionalHistograms) {
        this.listVoxels = listVoxels;
        this.dictionary = dictionary;
        this.listAdditionalHistograms = listAdditionalHistograms;
    }
}

