/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.slice;

import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.image.bean.provider.ChannelProviderUnary;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.spatial.box.Extent;

public class ExtractSliceRange
extends ChannelProviderUnary {
    @BeanField
    @Positive
    private int indexStart;
    @BeanField
    @Positive
    private int indexEnd;
    @BeanField
    private boolean duplicate = true;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        if (this.indexEnd < this.indexStart) {
            throw new BeanMisconfiguredException(String.format("indexStart (%d) must be less than indexEnd (%d)", this.indexStart, this.indexEnd));
        }
    }

    public Channel createFromChannel(Channel channel) {
        ChannelFactoryUnsignedByte factory = new ChannelFactoryUnsignedByte();
        Voxels voxels = channel.voxels().asByte();
        Extent extent = channel.extent().duplicateChangeZ(this.indexEnd - this.indexStart + 1);
        Channel channelOut = factory.createEmptyInitialised(new Dimensions(extent, channel.resolution()));
        Voxels voxelsOut = channelOut.voxels().asByte();
        for (int z = this.indexStart; z <= this.indexEnd; ++z) {
            voxelsOut.replaceSlice(z - this.indexStart, voxels.slice(z));
        }
        return channelOut;
    }

    @Generated
    public int getIndexStart() {
        return this.indexStart;
    }

    @Generated
    public void setIndexStart(int indexStart) {
        this.indexStart = indexStart;
    }

    @Generated
    public int getIndexEnd() {
        return this.indexEnd;
    }

    @Generated
    public void setIndexEnd(int indexEnd) {
        this.indexEnd = indexEnd;
    }
}

