/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.channel.provider.slice;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.ChannelProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.plugin.image.bean.channel.provider.FromDimensionsBase;

public class RepeatSlice
extends FromDimensionsBase {
    @BeanField
    private ChannelProvider slice;

    @Override
    protected Channel createFromDimensions(Dimensions dimensions) throws ProvisionFailedException {
        Channel sliceCreated = (Channel)this.slice.get();
        Dimensions dimensionsSource = sliceCreated.dimensions();
        if (dimensionsSource.x() != dimensions.x()) {
            throw new ProvisionFailedException("x dimension is not equal");
        }
        if (dimensionsSource.y() != dimensions.y()) {
            throw new ProvisionFailedException("y dimension is not equal");
        }
        Channel channelOut = ChannelFactory.instance().createUninitialised(dimensions, (VoxelDataType)UnsignedByteVoxelType.INSTANCE);
        Voxels voxelsSlice = sliceCreated.voxels().asByte();
        Voxels voxelsOut = channelOut.voxels().asByte();
        voxelsOut.extent().iterateOverZ(z -> voxelsOut.replaceSlice(z, voxelsSlice.duplicate().slice(0)));
        return channelOut;
    }

    @Generated
    public ChannelProvider getSlice() {
        return this.slice;
    }

    @Generated
    public void setSlice(ChannelProvider slice) {
        this.slice = slice;
    }
}

