/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.dimensions.provider;

import java.util.Set;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.core.identifier.provider.store.NamedProviderStore;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.DimensionsProvider;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.Stack;

public class GuessDimensions
extends DimensionsProvider {
    private Dimensions dimensions;

    public Dimensions get() throws ProvisionFailedException {
        if (this.dimensions == null) {
            try {
                this.dimensions = this.takeDimensionFromStackCollection((NamedProviderStore<Stack>)((ImageInitialization)this.getInitialization()).stacks());
            }
            catch (InitializeException e) {
                throw new ProvisionFailedException((Throwable)e);
            }
        }
        return this.dimensions;
    }

    private Dimensions takeDimensionFromStackCollection(NamedProviderStore<Stack> stackCollection) throws ProvisionFailedException {
        Set keys = stackCollection.keys();
        if (!keys.contains("input_image")) {
            throw new ProvisionFailedException(String.format("No input-image (%s) exists so cannot guess image dimensions. Please set the dimensions explicitly.", "input_image"));
        }
        return this.dimensionsFromSpecificStack("input_image");
    }

    private Dimensions dimensionsFromSpecificStack(String keyThatExists) throws ProvisionFailedException {
        Stack stack;
        try {
            stack = (Stack)((ImageInitialization)this.getInitialization()).stacks().getException(keyThatExists);
        }
        catch (InitializeException | NamedProviderGetException e) {
            throw new ProvisionFailedException(e);
        }
        Channel channel = stack.getChannel(0);
        if (channel == null) {
            throw new ProvisionFailedException(String.format("Stack %s has no channels, so dimensions cannot be inferred.", keyThatExists));
        }
        return channel.dimensions();
    }
}

