/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.histogram.threshold;

import com.google.common.base.Preconditions;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.CalculateLevelUnary;
import org.anchoranalysis.math.histogram.Histogram;

public class ClampHistogramMax
extends CalculateLevelUnary {
    @BeanField
    private int max;

    public int calculateLevel(Histogram histogram) throws OperationFailedException {
        return this.calculateLevelFromDelegate(ClampHistogramMax.createClamped(histogram, this.max));
    }

    private static Histogram createClamped(Histogram histogram, int maxVal) {
        Preconditions.checkArgument((maxVal <= histogram.getMaxValue() ? 1 : 0) != 0);
        long numAbove = histogram.countMatching(value -> value > maxVal);
        Histogram out = new Histogram(histogram.getMaxValue());
        histogram.iterateValuesUntil(maxVal, (arg_0, arg_1) -> ((Histogram)out).incrementValueBy(arg_0, arg_1));
        out.incrementValueBy(maxVal, numAbove);
        return out;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClampHistogramMax)) {
            return false;
        }
        ClampHistogramMax other = (ClampHistogramMax)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return this.getMax() == other.getMax();
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ClampHistogramMax;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getMax();
        return result;
    }

    @Generated
    public int getMax() {
        return this.max;
    }

    @Generated
    public void setMax(int max) {
        this.max = max;
    }
}

