/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.histogram.threshold;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.CalculateLevel;
import org.anchoranalysis.math.histogram.Histogram;
import org.anchoranalysis.math.statistics.VarianceCalculatorLong;

public class OtsuWeighted
extends CalculateLevel {
    @BeanField
    private double weightForeground = 1.0;
    @BeanField
    private double weightBackground = 1.0;

    public int calculateLevel(Histogram histogram) throws OperationFailedException {
        this.getLogger().messageLogger().logFormatted("weightForeground=%f weightBackground=%f", new Object[]{this.weightForeground, this.weightBackground});
        int minIntensity = histogram.calculateMinimum() + 1;
        int maxIntensity = histogram.calculateMaximum() - 1;
        if (maxIntensity == -1) {
            return 0;
        }
        int thresholdChosen = this.findBestThreshold(histogram, minIntensity, maxIntensity);
        this.getLogger().messageLogger().logFormatted("chosen threshold=%d", new Object[]{thresholdChosen});
        return thresholdChosen;
    }

    private int findBestThreshold(Histogram histogram, int minIntensity, int maxIntensity) {
        int bestThreshold = 0;
        VarianceCalculatorLong total = OtsuWeighted.varianceCalculatorTotal(histogram);
        VarianceCalculatorLong running = OtsuWeighted.varianceCalculatorFirstBin(histogram, minIntensity - 1);
        double scoreMin = Double.POSITIVE_INFINITY;
        for (int level = minIntensity; level <= maxIntensity; ++level) {
            running.add(level, histogram.getCount(level));
            double score = this.weightedSumClassVariances(running, total);
            if (!(score <= scoreMin) || Double.isNaN(score)) continue;
            scoreMin = score;
            bestThreshold = level;
        }
        return bestThreshold;
    }

    private static VarianceCalculatorLong varianceCalculatorFirstBin(Histogram histogram, int firstBin) {
        VarianceCalculatorLong running = new VarianceCalculatorLong(0L, 0L, 0L);
        running.add(firstBin, histogram.getCount(firstBin));
        return running;
    }

    private static VarianceCalculatorLong varianceCalculatorTotal(Histogram histogram) {
        return new VarianceCalculatorLong(histogram.calculateSum(), histogram.calculateSumSquares(), histogram.getTotalCount());
    }

    private double weightedSumClassVariances(VarianceCalculatorLong running, VarianceCalculatorLong total) {
        double varianceBackground = running.variance();
        double varianceForeground = total.subtract(running).variance();
        double prob1 = (double)running.getCount() / (double)total.getCount();
        double prob2 = 1.0 - prob1;
        return prob1 * varianceBackground * this.weightBackground + prob2 * varianceForeground * this.weightForeground;
    }

    @Generated
    public OtsuWeighted() {
    }

    @Generated
    public OtsuWeighted(double weightForeground, double weightBackground) {
        this.weightForeground = weightForeground;
        this.weightBackground = weightBackground;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OtsuWeighted)) {
            return false;
        }
        OtsuWeighted other = (OtsuWeighted)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (Double.compare(this.getWeightForeground(), other.getWeightForeground()) != 0) {
            return false;
        }
        return Double.compare(this.getWeightBackground(), other.getWeightBackground()) == 0;
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof OtsuWeighted;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $weightForeground = Double.doubleToLongBits(this.getWeightForeground());
        result = result * 59 + (int)($weightForeground >>> 32 ^ $weightForeground);
        long $weightBackground = Double.doubleToLongBits(this.getWeightBackground());
        result = result * 59 + (int)($weightBackground >>> 32 ^ $weightBackground);
        return result;
    }

    @Generated
    public double getWeightForeground() {
        return this.weightForeground;
    }

    @Generated
    public void setWeightForeground(double weightForeground) {
        this.weightForeground = weightForeground;
    }

    @Generated
    public double getWeightBackground() {
        return this.weightBackground;
    }

    @Generated
    public void setWeightBackground(double weightBackground) {
        this.weightBackground = weightBackground;
    }
}

