/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.bean.provider.MaskProviderUnary;
import org.anchoranalysis.image.core.mask.IterateVoxelsMask;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.mask.MaskInverter;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;

public class Invert
extends MaskProviderUnary {
    @BeanField
    @OptionalBean
    private MaskProvider restrictTo;
    @BeanField
    private boolean forceChangeBytes = false;

    public Mask createFromMask(Mask maskToInvert) throws ProvisionFailedException {
        Optional restricted = OptionalProviderFactory.create((Provider)this.restrictTo);
        if (restricted.isPresent()) {
            this.invertWithMask(maskToInvert, (Mask)restricted.get());
            return maskToInvert;
        }
        if (this.forceChangeBytes) {
            MaskInverter.invert((Mask)maskToInvert);
            return maskToInvert;
        }
        return new Mask(maskToInvert.channel(), maskToInvert.binaryValuesInt().createInverted());
    }

    private void invertWithMask(Mask maskToInvert, Mask restricted) {
        BinaryValuesByte invertedIndex = maskToInvert.binaryValuesByte();
        byte byteOn = invertedIndex.getOn();
        byte byteOff = invertedIndex.getOff();
        IterateVoxelsMask.withBuffer((Mask)restricted, (Voxels)maskToInvert.binaryVoxels().voxels(), (point, buffer, offset) -> {
            if (buffer.getRaw(offset) == byteOn) {
                buffer.putRaw(offset, byteOff);
            } else {
                buffer.putRaw(offset, byteOn);
            }
        });
    }

    @Generated
    public MaskProvider getRestrictTo() {
        return this.restrictTo;
    }

    @Generated
    public void setRestrictTo(MaskProvider restrictTo) {
        this.restrictTo = restrictTo;
    }

    @Generated
    public boolean isForceChangeBytes() {
        return this.forceChangeBytes;
    }

    @Generated
    public void setForceChangeBytes(boolean forceChangeBytes) {
        this.forceChangeBytes = forceChangeBytes;
    }
}

