/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider.morphological;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.morphological.DilationContext;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalDilation;
import org.anchoranalysis.plugin.image.bean.mask.provider.morphological.MorphologicalOperatorBase;

public class Dilate
extends MorphologicalOperatorBase {
    @BeanField
    private boolean bigNeighborhood = false;

    @Override
    protected void applyMorphologicalOperation(Mask source, boolean do3D) {
        try {
            BinaryVoxels out = MorphologicalDilation.dilate((BinaryVoxels)source.binaryVoxels(), (int)this.getIterations(), (DilationContext)new DilationContext(OutsideKernelPolicy.AS_OFF, do3D, this.bigNeighborhood, this.precondition()));
            source.replaceBy(out);
        }
        catch (ProvisionFailedException | CreateException | IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    @Generated
    public boolean isBigNeighborhood() {
        return this.bigNeighborhood;
    }

    @Generated
    public void setBigNeighborhood(boolean bigNeighborhood) {
        this.bigNeighborhood = bigNeighborhood;
    }
}

