/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.mask.provider.segment;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.nonbean.segment.BinarySegmentationParameters;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.provider.HistogramProvider;
import org.anchoranalysis.image.bean.provider.MaskProvider;
import org.anchoranalysis.image.bean.segment.binary.BinarySegmentation;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.mask.provider.FromChannelBase;
import org.anchoranalysis.plugin.image.bean.mask.provider.segment.ChannelCreatorHelper;

public class SegmentChannel
extends FromChannelBase {
    @BeanField
    private BinarySegmentation segment;
    @BeanField
    @OptionalBean
    private HistogramProvider histogram;
    @BeanField
    @OptionalBean
    private MaskProvider mask;

    @Override
    protected Mask createFromSource(Channel source) throws CreateException {
        return new Mask(this.segmentChannel(source), source.resolution());
    }

    private BinaryVoxels<UnsignedByteBuffer> segmentChannel(Channel channel) throws CreateException {
        try {
            Optional<ObjectMask> object = this.objectFromMask(channel.dimensions());
            BinarySegmentationParameters parameters = this.createParameters(channel.dimensions());
            return this.segment.segment(channel.voxels(), parameters, object);
        }
        catch (ProvisionFailedException | SegmentationFailedException e) {
            throw new CreateException(e);
        }
    }

    private BinarySegmentationParameters createParameters(Dimensions dimensions) throws ProvisionFailedException {
        return new BinarySegmentationParameters(OptionalProviderFactory.create((Provider)this.histogram), dimensions.resolution());
    }

    private Optional<ObjectMask> objectFromMask(Dimensions dim) throws ProvisionFailedException {
        Optional<Mask> maskChannel = ChannelCreatorHelper.createOptionalCheckSize(this.mask, "mask", dim);
        return maskChannel.map(channel -> new ObjectMask(channel.binaryVoxels()));
    }

    @Generated
    public BinarySegmentation getSegment() {
        return this.segment;
    }

    @Generated
    public void setSegment(BinarySegmentation segment) {
        this.segment = segment;
    }

    @Generated
    public HistogramProvider getHistogram() {
        return this.histogram;
    }

    @Generated
    public void setHistogram(HistogramProvider histogram) {
        this.histogram = histogram;
    }

    @Generated
    public MaskProvider getMask() {
        return this.mask;
    }

    @Generated
    public void setMask(MaskProvider mask) {
        this.mask = mask;
    }
}

