/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter;

import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.object.ObjectFilter;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public abstract class ObjectFilterPredicate
extends ObjectFilter {
    public ObjectCollection filter(ObjectCollection objectsToFilter, Optional<Dimensions> dimensions) throws OperationFailedException {
        if (!this.precondition(objectsToFilter)) {
            return objectsToFilter;
        }
        this.start(dimensions, objectsToFilter);
        ObjectCollection filtered = objectsToFilter.stream().filter(object -> this.match((ObjectMask)object, dimensions), OperationFailedException.class);
        this.end();
        return filtered;
    }

    protected abstract boolean precondition(ObjectCollection var1);

    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
    }

    protected abstract boolean match(ObjectMask var1, Optional<Dimensions> var2) throws OperationFailedException;

    protected abstract void end() throws OperationFailedException;
}

