/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.collective;

import cern.colt.list.DoubleArrayList;
import cern.jet.stat.Descriptive;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterPredicate;

public class DiscardOutliers
extends ObjectFilterPredicate {
    @BeanField
    private FeatureEvaluator<FeatureInputSingleObject> featureEvaluator;
    @BeanField
    private double quantile;
    @BeanField
    private double minRatio;
    @BeanField
    private int minNumberObjects = 1;
    private double minVal;
    private DoubleArrayList featureVals;
    private Map<ObjectMask, Double> featureMap;

    @Override
    protected boolean precondition(ObjectCollection objectsToFilter) {
        return objectsToFilter.size() >= this.minNumberObjects;
    }

    @Override
    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
        super.start(dimensions, objectsToFilter);
        this.featureVals = DiscardOutliers.calculateFeatures(objectsToFilter, (FeatureCalculatorSingle<FeatureInputSingleObject>)this.featureEvaluator.createFeatureSession());
        this.featureMap = DiscardOutliers.createFeatureMap(objectsToFilter, this.featureVals);
        double quantileVal = this.calculateQuantile(this.featureVals);
        this.minVal = quantileVal * this.minRatio;
        if (this.getLogger() != null) {
            this.getLogger().messageLogger().log("START DiscardOutliers");
            this.getLogger().messageLogger().logFormatted("quantileVal(%f)=%f   minVal=%f", new Object[]{this.quantile, quantileVal, this.minVal});
        }
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dimensions) throws OperationFailedException {
        boolean matched;
        double featureVal = this.featureMap.get(object);
        boolean bl = matched = featureVal >= this.minVal;
        if (!matched && this.getLogger() != null) {
            this.getLogger().messageLogger().logFormatted("discard with val=%f", new Object[]{featureVal});
        }
        return matched;
    }

    @Override
    protected void end() throws OperationFailedException {
        this.featureVals = null;
        if (this.getLogger() != null) {
            this.getLogger().messageLogger().log("END DiscardOutliers");
        }
    }

    private static DoubleArrayList calculateFeatures(ObjectCollection objects, FeatureCalculatorSingle<FeatureInputSingleObject> calculator) throws OperationFailedException {
        DoubleArrayList featureVals = new DoubleArrayList();
        for (ObjectMask objectMask : objects) {
            try {
                featureVals.add(calculator.calculate((FeatureInput)new FeatureInputSingleObject(objectMask)));
            }
            catch (FeatureCalculationException e) {
                throw new OperationFailedException((Throwable)e);
            }
        }
        return featureVals;
    }

    private static Map<ObjectMask, Double> createFeatureMap(ObjectCollection objectsToFilter, DoubleArrayList featureVals) {
        assert (objectsToFilter.size() == featureVals.size());
        HashMap<ObjectMask, Double> map = new HashMap<ObjectMask, Double>();
        for (int i = 0; i < objectsToFilter.size(); ++i) {
            map.put(objectsToFilter.get(i), featureVals.get(i));
        }
        return map;
    }

    private double calculateQuantile(DoubleArrayList featureVals) {
        DoubleArrayList featureValsSorted = featureVals.copy();
        featureValsSorted.sort();
        return Descriptive.quantile((DoubleArrayList)featureValsSorted, (double)this.quantile);
    }

    @Generated
    public FeatureEvaluator<FeatureInputSingleObject> getFeatureEvaluator() {
        return this.featureEvaluator;
    }

    @Generated
    public void setFeatureEvaluator(FeatureEvaluator<FeatureInputSingleObject> featureEvaluator) {
        this.featureEvaluator = featureEvaluator;
    }

    @Generated
    public double getQuantile() {
        return this.quantile;
    }

    @Generated
    public void setQuantile(double quantile) {
        this.quantile = quantile;
    }

    @Generated
    public double getMinRatio() {
        return this.minRatio;
    }

    @Generated
    public void setMinRatio(double minRatio) {
        this.minRatio = minRatio;
    }

    @Generated
    public int getMinNumberObjects() {
        return this.minNumberObjects;
    }

    @Generated
    public void setMinNumberObjects(int minNumberObjects) {
        this.minNumberObjects = minNumberObjects;
    }
}

