/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.collective;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.calculator.FeatureCalculatorCache;
import org.anchoranalysis.image.bean.object.ObjectMatcher;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.relation.DoubleBiPredicate;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterRelation;

public class RelationWithMatches
extends ObjectFilterRelation {
    @BeanField
    private FeatureEvaluator<FeatureInputSingleObject> featureEvaluator;
    @BeanField
    @OptionalBean
    private FeatureEvaluator<FeatureInputSingleObject> featureEvaluatorMatch;
    @BeanField
    private ObjectMatcher matcher;
    @BeanField
    private int cacheSize = 50;
    private FeatureCalculatorSingle<FeatureInputSingleObject> evaluatorForMatch;
    private FeatureCalculatorSingle<FeatureInputSingleObject> evaluatorForSource;
    private Map<ObjectMask, ObjectCollection> matches;

    @Override
    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
        super.start(dimensions, objectsToFilter);
        this.setupEvaluators();
        this.matches = RelationWithMatches.createMatchesMap(this.matcher.findMatch(objectsToFilter));
        if (this.matches.values().stream().anyMatch(ObjectCollection::isEmpty)) {
            throw new OperationFailedException("No matches found for at least one object");
        }
    }

    private void setupEvaluators() throws OperationFailedException {
        this.evaluatorForSource = this.featureEvaluator.createFeatureSession();
        FeatureCalculatorSingle calculator = this.featureEvaluatorMatch != null ? this.featureEvaluatorMatch.createFeatureSession() : this.evaluatorForSource;
        this.evaluatorForMatch = FeatureCalculatorCache.cache((FeatureCalculatorSingle)calculator, (int)this.cacheSize);
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dim, DoubleBiPredicate relation) throws OperationFailedException {
        try {
            double val = this.evaluatorForSource.calculate((FeatureInput)new FeatureInputSingleObject(object));
            return this.doesMatchAllAssociatedObjects(val, this.matches.get(object), relation);
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Override
    protected void end() throws OperationFailedException {
        super.end();
        this.evaluatorForMatch = null;
        this.evaluatorForSource = null;
        this.matches = null;
    }

    private boolean doesMatchAllAssociatedObjects(double val, ObjectCollection matches, DoubleBiPredicate relation) throws FeatureCalculationException {
        for (ObjectMask match : matches) {
            double valMatch = this.evaluatorForMatch.calculate((FeatureInput)new FeatureInputSingleObject(match));
            if (relation.test(val, valMatch)) continue;
            return false;
        }
        return true;
    }

    private static Map<ObjectMask, ObjectCollection> createMatchesMap(List<MatchedObject> list) {
        return list.stream().collect(Collectors.toMap(MatchedObject::getSource, MatchedObject::getMatches));
    }

    @Generated
    public FeatureEvaluator<FeatureInputSingleObject> getFeatureEvaluator() {
        return this.featureEvaluator;
    }

    @Generated
    public void setFeatureEvaluator(FeatureEvaluator<FeatureInputSingleObject> featureEvaluator) {
        this.featureEvaluator = featureEvaluator;
    }

    @Generated
    public FeatureEvaluator<FeatureInputSingleObject> getFeatureEvaluatorMatch() {
        return this.featureEvaluatorMatch;
    }

    @Generated
    public void setFeatureEvaluatorMatch(FeatureEvaluator<FeatureInputSingleObject> featureEvaluatorMatch) {
        this.featureEvaluatorMatch = featureEvaluatorMatch;
    }

    @Generated
    public ObjectMatcher getMatcher() {
        return this.matcher;
    }

    @Generated
    public void setMatcher(ObjectMatcher matcher) {
        this.matcher = matcher;
    }

    @Generated
    public int getCacheSize() {
        return this.cacheSize;
    }

    @Generated
    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }
}

