/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.independent;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.relation.DoubleBiPredicate;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterRelation;

public class ThresholdedFeature
extends ObjectFilterRelation {
    @BeanField
    private FeatureEvaluator<FeatureInputSingleObject> featureEvaluator;
    @BeanField
    private double threshold;
    @BeanField
    private boolean debug = true;
    private FeatureCalculatorSingle<FeatureInputSingleObject> featureSession = null;

    @Override
    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
        super.start(dimensions, objectsToFilter);
        if (this.featureSession == null) {
            this.featureSession = this.featureEvaluator.createFeatureSession();
        }
        if (this.debug) {
            this.getLogger().messageLogger().log("START Feature Threshold");
        }
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dim, DoubleBiPredicate relation) throws OperationFailedException {
        double value;
        try {
            value = this.featureSession.calculate((FeatureInput)new FeatureInputSingleObject(object));
        }
        catch (FeatureCalculationException e) {
            throw new OperationFailedException((Throwable)e);
        }
        boolean matched = relation.test(value, this.threshold);
        if (this.debug) {
            if (matched) {
                this.getLogger().messageLogger().logFormatted("%s\tVal=%f\tthreshold=%f\t  (Accepted)", new Object[]{object.centerOfGravity(), value, this.threshold});
            } else {
                this.getLogger().messageLogger().logFormatted("%s\tVal=%f\tthreshold=%f", new Object[]{object.centerOfGravity(), value, this.threshold});
            }
        }
        return matched;
    }

    @Override
    protected void end() throws OperationFailedException {
        if (this.debug) {
            this.getLogger().messageLogger().log("END Feature Threshold");
        }
    }

    @Generated
    public FeatureEvaluator<FeatureInputSingleObject> getFeatureEvaluator() {
        return this.featureEvaluator;
    }

    @Generated
    public void setFeatureEvaluator(FeatureEvaluator<FeatureInputSingleObject> featureEvaluator) {
        this.featureEvaluator = featureEvaluator;
    }

    @Generated
    public double getThreshold() {
        return this.threshold;
    }

    @Generated
    public void setThreshold(double threshold) {
        this.threshold = threshold;
    }

    @Generated
    public boolean isDebug() {
        return this.debug;
    }

    @Generated
    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

