/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.filter.independent;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.UnitValueException;
import org.anchoranalysis.image.bean.unitvalue.extent.volume.UnitValueVolume;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.math.relation.DoubleBiPredicate;
import org.anchoranalysis.plugin.image.bean.object.filter.ObjectFilterRelation;

public class ThresholdedVolume
extends ObjectFilterRelation {
    @BeanField
    private UnitValueVolume threshold;
    private int thresholdResolved;

    @Override
    protected void start(Optional<Dimensions> dimensions, ObjectCollection objectsToFilter) throws OperationFailedException {
        super.start(dimensions, objectsToFilter);
        this.thresholdResolved = this.resolveThreshold(dimensions);
    }

    @Override
    protected boolean match(ObjectMask object, Optional<Dimensions> dim, DoubleBiPredicate relation) {
        return relation.test((double)object.numberVoxelsOn(), (double)this.thresholdResolved);
    }

    private int resolveThreshold(Optional<Dimensions> dim) throws OperationFailedException {
        try {
            return (int)Math.floor(this.threshold.resolveToVoxels(dim.flatMap(Dimensions::unitConvert)));
        }
        catch (UnitValueException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    @Generated
    public UnitValueVolume getThreshold() {
        return this.threshold;
    }

    @Generated
    public void setThreshold(UnitValueVolume threshold) {
        this.threshold = threshold;
    }
}

