/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.match;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.object.ObjectMatcher;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class Always
extends ObjectMatcher {
    @BeanField
    private ObjectCollectionProvider objects;

    public List<MatchedObject> findMatch(ObjectCollection sourceObjects) throws OperationFailedException {
        ObjectMask match = this.determineMatch();
        return sourceObjects.stream().mapToList(object -> new MatchedObject(object, ObjectCollectionFactory.of((ObjectMask[])new ObjectMask[]{match})));
    }

    private ObjectMask determineMatch() throws OperationFailedException {
        ObjectCollection collection;
        try {
            collection = (ObjectCollection)this.objects.get();
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
        if (collection.size() == 0) {
            throw new OperationFailedException("No objects provided");
        }
        if (collection.size() > 1) {
            throw new OperationFailedException("More than one objects provided");
        }
        return collection.get(0);
    }

    @Generated
    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    @Generated
    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }
}

