/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.match;

import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.object.ObjectMatcher;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;

public class Bridge
extends ObjectMatcher {
    @BeanField
    private ObjectMatcher bridgeMatcher;
    @BeanField
    private ObjectMatcher objectMatcher;

    public List<MatchedObject> findMatch(ObjectCollection sourceObjects) throws OperationFailedException {
        List bridgeMatches = this.bridgeMatcher.findMatch(sourceObjects);
        ObjectCollection bridgeObjects = ObjectCollectionFactory.flatMapFrom(bridgeMatches.stream().map(MatchedObject::getMatches), OperationFailedException.class, Bridge::checkExactlyOneMatch);
        return this.objectMatcher.findMatch(bridgeObjects);
    }

    private static ObjectCollection checkExactlyOneMatch(ObjectCollection matches) throws OperationFailedException {
        if (matches.size() == 0) {
            throw new OperationFailedException("At least one object has no match. One is needed");
        }
        if (matches.size() > 1) {
            throw new OperationFailedException("At least one object has multiple matches. Only one is allowed.");
        }
        return matches;
    }

    @Generated
    public ObjectMatcher getBridgeMatcher() {
        return this.bridgeMatcher;
    }

    @Generated
    public void setBridgeMatcher(ObjectMatcher bridgeMatcher) {
        this.bridgeMatcher = bridgeMatcher;
    }

    @Generated
    public ObjectMatcher getObjectMatcher() {
        return this.objectMatcher;
    }

    @Generated
    public void setObjectMatcher(ObjectMatcher objectMatcher) {
        this.objectMatcher = objectMatcher;
    }
}

