/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.merge;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.object.merge.condition.AfterCondition;
import org.anchoranalysis.plugin.image.object.merge.condition.BeforeCondition;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.PointConverter;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.point.Tuple3d;

class NaiveGreedyMerge {
    private final boolean replaceWithMidpoint;
    private final BeforeCondition beforeCondition;
    private final AfterCondition afterCondition;
    private final Optional<UnitConverter> unitConverter;
    private final Logger logger;

    public ObjectCollection tryMerge(ObjectCollection objects) throws OperationFailedException {
        ArrayDeque<MergeRange> stack = new ArrayDeque<MergeRange>();
        stack.add(new MergeRange(0, 0));
        while (!stack.isEmpty()) {
            this.tryMergeWithinRange(objects, (MergeRange)stack.pop(), stack::push);
        }
        return objects;
    }

    private void tryMergeWithinRange(ObjectCollection objects, MergeRange range, Consumer<MergeRange> consumer) throws OperationFailedException {
        try {
            this.afterCondition.initialize(this.logger);
        }
        catch (InitializeException e) {
            throw new OperationFailedException((Throwable)e);
        }
        for (int i = range.getStart(); i < objects.size(); ++i) {
            for (int j = range.getEnd(); !(j >= objects.size() || i != j && this.tryMergeOnIndices(objects.asList(), i, j, consumer)); ++j) {
            }
        }
    }

    private boolean tryMergeOnIndices(List<ObjectMask> objects, int i, int j, Consumer<MergeRange> consumer) throws OperationFailedException {
        Optional<ObjectMask> merged = this.tryMerge(objects.get(i), objects.get(j));
        if (merged.isPresent()) {
            NaiveGreedyMerge.removeTwoIndices(objects, i, j);
            objects.add(merged.get());
            int startPos = Math.max(i - 1, 0);
            consumer.accept(new MergeRange(startPos, startPos));
            return true;
        }
        return false;
    }

    private Optional<ObjectMask> tryMerge(ObjectMask source, ObjectMask destination) throws OperationFailedException {
        if (!this.beforeCondition.accept(source, destination, this.unitConverter)) {
            return Optional.empty();
        }
        ObjectMask merged = this.merge(source, destination);
        if (!this.afterCondition.accept(source, destination, merged)) {
            return Optional.empty();
        }
        return Optional.of(merged);
    }

    private ObjectMask merge(ObjectMask source, ObjectMask destination) {
        if (this.replaceWithMidpoint) {
            Point3i pointNew = PointConverter.intFromDoubleFloor((Point3d)NaiveGreedyMerge.midPointBetween(source.boundingBox().midpoint(), destination.boundingBox().midpoint()));
            return NaiveGreedyMerge.createSinglePixelObject(pointNew);
        }
        return ObjectMaskMerger.merge((ObjectMask)source, (ObjectMask)destination);
    }

    private static ObjectMask createSinglePixelObject(Point3i point) {
        Extent extent = new Extent(1, 1, 1);
        BinaryVoxels voxels = BinaryVoxelsFactory.createEmptyOn((Extent)extent);
        return new ObjectMask(BoundingBox.createReuse((ReadableTuple3i)point, (Extent)extent), voxels);
    }

    private static void removeTwoIndices(List<ObjectMask> objects, int i, int j) {
        if (i < j) {
            objects.remove(j);
            objects.remove(i);
        } else {
            objects.remove(i);
            objects.remove(j);
        }
    }

    private static Point3d midPointBetween(Point3d point1, Point3d point2) {
        Point3d pointNew = new Point3d((Tuple3d)point1);
        pointNew.add((Tuple3d)point2);
        pointNew.scale(0.5);
        return pointNew;
    }

    @Generated
    public NaiveGreedyMerge(boolean replaceWithMidpoint, BeforeCondition beforeCondition, AfterCondition afterCondition, Optional<UnitConverter> unitConverter, Logger logger) {
        this.replaceWithMidpoint = replaceWithMidpoint;
        this.beforeCondition = beforeCondition;
        this.afterCondition = afterCondition;
        this.unitConverter = unitConverter;
        this.logger = logger;
    }

    private static final class MergeRange {
        private final int start;
        private final int end;

        @Generated
        public MergeRange(int start, int end) {
            this.start = start;
            this.end = end;
        }

        @Generated
        public int getStart() {
            return this.start;
        }

        @Generated
        public int getEnd() {
            return this.end;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeRange)) {
                return false;
            }
            MergeRange other = (MergeRange)o;
            if (this.getStart() != other.getStart()) {
                return false;
            }
            return this.getEnd() == other.getEnd();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStart();
            result = result * 59 + this.getEnd();
            return result;
        }

        @Generated
        public String toString() {
            return "NaiveGreedyMerge.MergeRange(start=" + this.getStart() + ", end=" + this.getEnd() + ")";
        }
    }
}

