/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.segment;

import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.bean.segment.object.SegmentChannelIntoObjects;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactory;
import org.anchoranalysis.image.core.object.MatchedObject;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.match.MatcherIntersectionHelper;
import org.anchoranalysis.plugin.image.bean.object.provider.WithChannelBase;
import org.anchoranalysis.plugin.image.bean.object.provider.segment.SeedsFactory;
import org.anchoranalysis.spatial.box.BoundingBox;

public class SegmentWithSeeds
extends WithChannelBase {
    @BeanField
    @OptionalBean
    private ObjectCollectionProvider objectsSource;
    @BeanField
    private ObjectCollectionProvider objectsSeeds;
    @BeanField
    private SegmentChannelIntoObjects segment;

    @Override
    protected ObjectCollection createFromChannel(Channel channel) throws ProvisionFailedException {
        ObjectCollection seeds = (ObjectCollection)this.objectsSeeds.get();
        if (this.objectsSource != null) {
            ObjectCollection sourceObjects = (ObjectCollection)this.objectsSource.get();
            return SegmentWithSeeds.createWithSourceObjects(channel, seeds, sourceObjects, this.segment);
        }
        return SegmentWithSeeds.createWithoutSourceObjects(channel, seeds, this.segment);
    }

    private static ObjectCollection createWithSourceObjects(Channel channel, ObjectCollection seeds, ObjectCollection sourceObjects, SegmentChannelIntoObjects segment) throws ProvisionFailedException {
        assert (seeds != null);
        assert (sourceObjects != null);
        List<MatchedObject> matchList = MatcherIntersectionHelper.matchIntersectingObjects(sourceObjects, seeds);
        return ObjectCollectionFactory.flatMapFrom(matchList.stream(), CreateException.class, ows -> SegmentWithSeeds.segmentIfMoreThanOne(ows, channel, segment));
    }

    private static ObjectCollection segmentIfMoreThanOne(MatchedObject ows, Channel channel, SegmentChannelIntoObjects segment) throws ProvisionFailedException {
        if (ows.numberMatches() <= 1) {
            return ObjectCollectionFactory.of((ObjectMask[])new ObjectMask[]{ows.getSource()});
        }
        try {
            return SegmentWithSeeds.segment(ows, channel, segment);
        }
        catch (CreateException | SegmentationFailedException e) {
            throw new ProvisionFailedException(e);
        }
    }

    private static ObjectCollection createWithoutSourceObjects(Channel channel, ObjectCollection seedsAsObjects, SegmentChannelIntoObjects segment) throws ProvisionFailedException {
        try {
            return segment.segment(channel, Optional.empty(), Optional.of(SeedsFactory.createSeedsWithoutMask(seedsAsObjects)));
        }
        catch (SegmentationFailedException e) {
            throw new ProvisionFailedException((Throwable)e);
        }
    }

    private static ObjectCollection segment(MatchedObject matchedObject, Channel channel, SegmentChannelIntoObjects sgmn) throws SegmentationFailedException, CreateException {
        BoundingBox boxSource = matchedObject.getSource().boundingBox();
        ObjectMask objectLocal = new ObjectMask(matchedObject.getSource().binaryVoxels());
        ObjectCollection seedsObj = SeedsFactory.createSeedsWithMask(matchedObject.getMatches(), objectLocal, boxSource.cornerMin(), channel.dimensions());
        ObjectCollection sgmnObjects = sgmn.segment(SegmentWithSeeds.createChannelForBox(channel, boxSource), Optional.of(objectLocal), Optional.of(seedsObj));
        return sgmnObjects.shiftBy(boxSource.cornerMin());
    }

    private static Channel createChannelForBox(Channel channel, BoundingBox boundingBox) {
        return ChannelFactory.instance().create(channel.extract().region(boundingBox, false), channel.resolution());
    }

    @Generated
    public ObjectCollectionProvider getObjectsSource() {
        return this.objectsSource;
    }

    @Generated
    public void setObjectsSource(ObjectCollectionProvider objectsSource) {
        this.objectsSource = objectsSource;
    }

    @Generated
    public ObjectCollectionProvider getObjectsSeeds() {
        return this.objectsSeeds;
    }

    @Generated
    public void setObjectsSeeds(ObjectCollectionProvider objectsSeeds) {
        this.objectsSeeds = objectsSeeds;
    }

    @Generated
    public SegmentChannelIntoObjects getSegment() {
        return this.segment;
    }

    @Generated
    public void setSegment(SegmentChannelIntoObjects segment) {
        this.segment = segment;
    }
}

