/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.plugin.image.bean.object.provider.slice;

import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.plugin.image.bean.object.provider.WithDimensionsBase;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class ExtendInZ
extends WithDimensionsBase {
    public ObjectCollection createFromObjects(ObjectCollection objects) throws ProvisionFailedException {
        Dimensions dimensions = this.createDimensions();
        return objects.stream().map(objectMask -> ExtendInZ.expandZ(objectMask.flattenZ(), dimensions));
    }

    private static ObjectMask expandZ(ObjectMask object, Dimensions dim) {
        BoundingBox box = object.boundingBox().changeExtentZ(dim.z());
        Voxels<UnsignedByteBuffer> voxels = ExtendInZ.createVoxelsOfDuplicatedPlanes((VoxelBuffer<UnsignedByteBuffer>)object.voxels().slice(0), box.extent());
        return new ObjectMask(box, voxels, object.binaryValues());
    }

    private static Voxels<UnsignedByteBuffer> createVoxelsOfDuplicatedPlanes(VoxelBuffer<UnsignedByteBuffer> planeIn, Extent extent) {
        Voxels voxels = VoxelsFactory.getUnsignedByte().createInitialized(extent);
        for (int z = 0; z < extent.z(); ++z) {
            voxels.replaceSlice(z, planeIn);
        }
        return voxels;
    }
}

